#ifndef CUFFTDX_FFT_256_FP64_FWD_PTX_HPP
#define CUFFTDX_FFT_256_FP64_FWD_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<460, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<22>;
.reg .f64 fd<347>;
.reg .b64 rd<9>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 11;
mov.u32 r3, %16;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f64 fd33, %19, %29;
add.f64 fd34, %20, %31;
sub.f64 fd35, %19, %29;
sub.f64 fd36, %20, %31;
add.f64 fd37, %24, %35;
add.f64 fd38, %26, %36;
sub.f64 fd39, %24, %35;
sub.f64 fd40, %26, %36;
add.f64 fd41, fd33, fd37;
add.f64 fd42, fd34, fd38;
sub.f64 fd43, fd33, fd37;
sub.f64 fd44, fd34, fd38;
add.f64 fd45, fd35, fd40;
sub.f64 fd46, fd36, fd39;
sub.f64 fd47, fd35, fd40;
add.f64 fd48, fd36, fd39;
add.f64 fd49, %21, %32;
add.f64 fd50, %23, %34;
sub.f64 fd51, %21, %32;
sub.f64 fd52, %23, %34;
add.f64 fd53, %27, %37;
add.f64 fd54, %28, %38;
sub.f64 fd55, %27, %37;
sub.f64 fd56, %28, %38;
add.f64 fd57, fd49, fd53;
add.f64 fd58, fd50, fd54;
sub.f64 fd59, fd49, fd53;
sub.f64 fd60, fd50, fd54;
add.f64 fd61, fd51, fd56;
sub.f64 fd62, fd52, fd55;
sub.f64 fd63, fd51, fd56;
add.f64 fd64, fd52, fd55;
mul.f64 fd65, fd61, 0d3FE6A09E667F3BCD;
mul.f64 fd66, fd62, 0dBFE6A09E667F3BCD;
sub.f64 fd67, fd65, fd66;
mul.f64 fd68, fd62, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd69, fd61, 0dBFE6A09E667F3BCD, fd68;
mul.f64 fd70, fd63, 0dBFE6A09E667F3BCD;
mul.f64 fd71, fd64, 0dBFE6A09E667F3BCD;
sub.f64 fd72, fd70, fd71;
add.f64 fd73, fd70, fd71;
add.f64 fd74, fd41, fd57;
add.f64 fd75, fd42, fd58;
sub.f64 fd76, fd41, fd57;
sub.f64 fd77, fd42, fd58;
add.f64 fd78, fd45, fd67;
add.f64 fd79, fd46, fd69;
sub.f64 fd80, fd45, fd67;
sub.f64 fd81, fd46, fd69;
add.f64 fd82, fd43, fd60;
sub.f64 fd83, fd44, fd59;
sub.f64 fd84, fd43, fd60;
add.f64 fd85, fd44, fd59;
add.f64 fd86, fd47, fd72;
add.f64 fd87, fd48, fd73;
sub.f64 fd88, fd47, fd72;
sub.f64 fd89, fd48, fd73;
and.b32 r6, r5, 31;
shl.b32 r7, r5, 4;
cvt.u64.u32 rd2, r7;
and.b64 rd3, rd2, 496;
mov.u64 rd4, %17;
add.s64 rd5, rd4, rd3;
ld.global.v2.f64 {fd90, fd91}, [rd5];
mul.f64 fd94, fd90, fd78;
mul.f64 fd95, fd91, fd79;
sub.f64 fd96, fd94, fd95;
mul.f64 fd97, fd90, fd79;
fma.rn.f64 fd98, fd91, fd78, fd97;
mul.f64 fd99, fd90, fd90;
mul.f64 fd100, fd91, fd91;
sub.f64 fd101, fd99, fd100;
mul.f64 fd102, fd91, fd90;
fma.rn.f64 fd103, fd91, fd90, fd102;
mul.f64 fd104, fd101, fd82;
mul.f64 fd105, fd103, fd83;
sub.f64 fd106, fd104, fd105;
mul.f64 fd107, fd101, fd83;
fma.rn.f64 fd108, fd103, fd82, fd107;
mul.f64 fd109, fd90, fd101;
mul.f64 fd110, fd91, fd103;
sub.f64 fd111, fd109, fd110;
mul.f64 fd112, fd90, fd103;
fma.rn.f64 fd113, fd91, fd101, fd112;
mul.f64 fd114, fd111, fd86;
mul.f64 fd115, fd113, fd87;
sub.f64 fd116, fd114, fd115;
mul.f64 fd117, fd111, fd87;
fma.rn.f64 fd118, fd113, fd86, fd117;
mul.f64 fd119, fd90, fd111;
mul.f64 fd120, fd91, fd113;
sub.f64 fd121, fd119, fd120;
mul.f64 fd122, fd90, fd113;
fma.rn.f64 fd123, fd91, fd111, fd122;
mul.f64 fd124, fd121, fd76;
mul.f64 fd125, fd123, fd77;
sub.f64 fd126, fd124, fd125;
mul.f64 fd127, fd121, fd77;
fma.rn.f64 fd128, fd123, fd76, fd127;
ld.global.v2.f64 {fd129, fd130}, [rd5+512];
mul.f64 fd133, fd129, fd80;
mul.f64 fd134, fd130, fd81;
sub.f64 fd135, fd133, fd134;
mul.f64 fd136, fd129, fd81;
fma.rn.f64 fd137, fd130, fd80, fd136;
mul.f64 fd138, fd90, fd129;
mul.f64 fd139, fd91, fd130;
sub.f64 fd140, fd138, fd139;
mul.f64 fd141, fd90, fd130;
fma.rn.f64 fd142, fd91, fd129, fd141;
mul.f64 fd143, fd140, fd84;
mul.f64 fd144, fd142, fd85;
sub.f64 fd145, fd143, fd144;
mul.f64 fd146, fd140, fd85;
fma.rn.f64 fd147, fd142, fd84, fd146;
mul.f64 fd148, fd90, fd140;
mul.f64 fd149, fd91, fd142;
sub.f64 fd150, fd148, fd149;
mul.f64 fd151, fd90, fd142;
fma.rn.f64 fd152, fd91, fd140, fd151;
mul.f64 fd153, fd150, fd88;
mul.f64 fd154, fd152, fd89;
sub.f64 fd155, fd153, fd154;
mul.f64 fd156, fd150, fd89;
fma.rn.f64 fd157, fd152, fd88, fd156;
shl.b32 r8, r5, 6;
and.b32 r9, r8, -2048;
add.s32 r10, r4, r9;
barrier.sync 0;
and.b32 r11, r8, 1984;
add.s32 r12, r10, r11;
st.shared.v2.f64 [r12], {fd74, fd96};
st.shared.v2.f64 [r12+16], {fd106, fd116};
st.shared.v2.f64 [r12+32], {fd126, fd135};
st.shared.v2.f64 [r12+48], {fd145, fd155};
barrier.sync 0;
mad.lo.s32 r13, r6, -56, r12;
ld.shared.f64 fd158, [r13];
ld.shared.f64 fd159, [r13+256];
ld.shared.f64 fd160, [r13+512];
ld.shared.f64 fd161, [r13+768];
ld.shared.f64 fd162, [r13+1024];
ld.shared.f64 fd163, [r13+1280];
ld.shared.f64 fd164, [r13+1536];
ld.shared.f64 fd165, [r13+1792];
barrier.sync 0;
st.shared.v2.f64 [r12], {fd75, fd98};
st.shared.v2.f64 [r12+16], {fd108, fd118};
st.shared.v2.f64 [r12+32], {fd128, fd137};
st.shared.v2.f64 [r12+48], {fd147, fd157};
barrier.sync 0;
ld.shared.f64 fd166, [r13];
ld.shared.f64 fd167, [r13+256];
ld.shared.f64 fd168, [r13+512];
ld.shared.f64 fd169, [r13+768];
ld.shared.f64 fd170, [r13+1024];
ld.shared.f64 fd171, [r13+1280];
ld.shared.f64 fd172, [r13+1536];
ld.shared.f64 fd173, [r13+1792];
add.f64 fd174, fd158, fd162;
add.f64 fd175, fd166, fd170;
sub.f64 fd176, fd158, fd162;
sub.f64 fd177, fd166, fd170;
add.f64 fd178, fd160, fd164;
add.f64 fd179, fd168, fd172;
sub.f64 fd180, fd160, fd164;
sub.f64 fd181, fd168, fd172;
add.f64 fd182, fd174, fd178;
add.f64 fd183, fd175, fd179;
sub.f64 fd184, fd174, fd178;
sub.f64 fd185, fd175, fd179;
add.f64 fd186, fd176, fd181;
sub.f64 fd187, fd177, fd180;
sub.f64 fd188, fd176, fd181;
add.f64 fd189, fd177, fd180;
add.f64 fd190, fd159, fd163;
add.f64 fd191, fd167, fd171;
sub.f64 fd192, fd159, fd163;
sub.f64 fd193, fd167, fd171;
add.f64 fd194, fd161, fd165;
add.f64 fd195, fd169, fd173;
sub.f64 fd196, fd161, fd165;
sub.f64 fd197, fd169, fd173;
add.f64 fd198, fd190, fd194;
add.f64 fd199, fd191, fd195;
sub.f64 fd200, fd190, fd194;
sub.f64 fd201, fd191, fd195;
add.f64 fd202, fd192, fd197;
sub.f64 fd203, fd193, fd196;
sub.f64 fd204, fd192, fd197;
add.f64 fd205, fd193, fd196;
mul.f64 fd206, fd202, 0d3FE6A09E667F3BCD;
mul.f64 fd207, fd203, 0dBFE6A09E667F3BCD;
sub.f64 fd208, fd206, fd207;
mul.f64 fd209, fd203, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd210, fd202, 0dBFE6A09E667F3BCD, fd209;
mul.f64 fd211, fd204, 0dBFE6A09E667F3BCD;
mul.f64 fd212, fd205, 0dBFE6A09E667F3BCD;
sub.f64 fd213, fd211, fd212;
add.f64 fd214, fd211, fd212;
add.f64 fd215, fd182, fd198;
add.f64 fd216, fd183, fd199;
sub.f64 fd217, fd182, fd198;
sub.f64 fd218, fd183, fd199;
add.f64 fd219, fd186, fd208;
add.f64 fd220, fd187, fd210;
sub.f64 fd221, fd186, fd208;
sub.f64 fd222, fd187, fd210;
add.f64 fd223, fd184, fd201;
sub.f64 fd224, fd185, fd200;
sub.f64 fd225, fd184, fd201;
add.f64 fd226, fd185, fd200;
add.f64 fd227, fd188, fd213;
add.f64 fd228, fd189, fd214;
sub.f64 fd229, fd188, fd213;
sub.f64 fd230, fd189, fd214;
and.b32 r14, r5, 24;
bfe.u32 r15, r5, 3, 2;
mul.wide.u32 rd6, r15, 16;
mov.u64 rd7, %18;
add.s64 rd8, rd7, rd6;
ld.global.v2.f64 {fd231, fd232}, [rd8];
mul.f64 fd235, fd231, fd219;
mul.f64 fd236, fd232, fd220;
sub.f64 fd237, fd235, fd236;
mul.f64 fd238, fd231, fd220;
fma.rn.f64 fd239, fd232, fd219, fd238;
mul.f64 fd240, fd231, fd231;
mul.f64 fd241, fd232, fd232;
sub.f64 fd242, fd240, fd241;
mul.f64 fd243, fd232, fd231;
fma.rn.f64 fd244, fd232, fd231, fd243;
mul.f64 fd245, fd242, fd223;
mul.f64 fd246, fd244, fd224;
sub.f64 fd247, fd245, fd246;
mul.f64 fd248, fd242, fd224;
fma.rn.f64 fd249, fd244, fd223, fd248;
mul.f64 fd250, fd231, fd242;
mul.f64 fd251, fd232, fd244;
sub.f64 fd252, fd250, fd251;
mul.f64 fd253, fd231, fd244;
fma.rn.f64 fd254, fd232, fd242, fd253;
mul.f64 fd255, fd252, fd227;
mul.f64 fd256, fd254, fd228;
sub.f64 fd257, fd255, fd256;
mul.f64 fd258, fd252, fd228;
fma.rn.f64 fd259, fd254, fd227, fd258;
mul.f64 fd260, fd231, fd252;
mul.f64 fd261, fd232, fd254;
sub.f64 fd262, fd260, fd261;
mul.f64 fd263, fd231, fd254;
fma.rn.f64 fd264, fd232, fd252, fd263;
mul.f64 fd265, fd262, fd217;
mul.f64 fd266, fd264, fd218;
sub.f64 fd267, fd265, fd266;
mul.f64 fd268, fd262, fd218;
fma.rn.f64 fd269, fd264, fd217, fd268;
ld.global.v2.f64 {fd270, fd271}, [rd8+64];
mul.f64 fd274, fd270, fd221;
mul.f64 fd275, fd271, fd222;
sub.f64 fd276, fd274, fd275;
mul.f64 fd277, fd270, fd222;
fma.rn.f64 fd278, fd271, fd221, fd277;
mul.f64 fd279, fd231, fd270;
mul.f64 fd280, fd232, fd271;
sub.f64 fd281, fd279, fd280;
mul.f64 fd282, fd231, fd271;
fma.rn.f64 fd283, fd232, fd270, fd282;
mul.f64 fd284, fd281, fd225;
mul.f64 fd285, fd283, fd226;
sub.f64 fd286, fd284, fd285;
mul.f64 fd287, fd281, fd226;
fma.rn.f64 fd288, fd283, fd225, fd287;
mul.f64 fd289, fd231, fd281;
mul.f64 fd290, fd232, fd283;
sub.f64 fd291, fd289, fd290;
mul.f64 fd292, fd231, fd283;
fma.rn.f64 fd293, fd232, fd281, fd292;
mul.f64 fd294, fd291, fd229;
mul.f64 fd295, fd293, fd230;
sub.f64 fd296, fd294, fd295;
mul.f64 fd297, fd291, fd230;
fma.rn.f64 fd298, fd293, fd229, fd297;
shl.b32 r16, r5, 3;
and.b32 r17, r16, 56;
add.s32 r18, r10, r17;
barrier.sync 0;
and.b32 r19, r8, 1536;
add.s32 r20, r18, r19;
st.shared.f64 [r20], fd215;
st.shared.f64 [r20+64], fd237;
st.shared.f64 [r20+128], fd247;
st.shared.f64 [r20+192], fd257;
st.shared.f64 [r20+256], fd267;
st.shared.f64 [r20+320], fd276;
st.shared.f64 [r20+384], fd286;
st.shared.f64 [r20+448], fd296;
barrier.sync 0;
mad.lo.s32 r21, r14, -56, r20;
ld.shared.f64 fd299, [r21];
ld.shared.f64 fd300, [r21+256];
ld.shared.f64 fd301, [r21+512];
ld.shared.f64 fd302, [r21+768];
ld.shared.f64 fd303, [r21+1024];
ld.shared.f64 fd304, [r21+1280];
ld.shared.f64 fd305, [r21+1536];
ld.shared.f64 fd306, [r21+1792];
barrier.sync 0;
st.shared.f64 [r20], fd216;
st.shared.f64 [r20+64], fd239;
st.shared.f64 [r20+128], fd249;
st.shared.f64 [r20+192], fd259;
st.shared.f64 [r20+256], fd269;
st.shared.f64 [r20+320], fd278;
st.shared.f64 [r20+384], fd288;
st.shared.f64 [r20+448], fd298;
barrier.sync 0;
ld.shared.f64 fd307, [r21];
ld.shared.f64 fd308, [r21+256];
ld.shared.f64 fd309, [r21+512];
ld.shared.f64 fd310, [r21+768];
ld.shared.f64 fd311, [r21+1024];
ld.shared.f64 fd312, [r21+1280];
ld.shared.f64 fd313, [r21+1536];
ld.shared.f64 fd314, [r21+1792];
add.f64 fd315, fd299, fd303;
add.f64 fd316, fd307, fd311;
sub.f64 fd317, fd299, fd303;
sub.f64 fd318, fd307, fd311;
add.f64 fd319, fd301, fd305;
add.f64 fd320, fd309, fd313;
sub.f64 fd321, fd301, fd305;
sub.f64 fd322, fd309, fd313;
add.f64 fd323, fd300, fd304;
add.f64 fd324, fd308, fd312;
sub.f64 fd325, fd300, fd304;
sub.f64 fd326, fd308, fd312;
add.f64 fd327, fd302, fd306;
add.f64 fd328, fd310, fd314;
sub.f64 fd329, fd302, fd306;
sub.f64 fd330, fd310, fd314;
add.f64 %0, fd315, fd319;
add.f64 %1, fd316, fd320;
add.f64 %2, fd323, fd327;
add.f64 %3, fd324, fd328;
sub.f64 %5, fd318, fd321;
add.f64 %4, fd317, fd322;
sub.f64 %7, fd326, fd329;
add.f64 %6, fd325, fd330;
sub.f64 %8, fd315, fd319;
sub.f64 %9, fd316, fd320;
sub.f64 %10, fd323, fd327;
sub.f64 %11, fd324, fd328;
add.f64 %13, fd318, fd321;
sub.f64 %12, fd317, fd322;
add.f64 %15, fd326, fd329;
sub.f64 %14, fd325, fd330;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y): "r"(smem), "l"(lut_dp_8_256), "l"(lut_dp_8_32), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<461, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<24>;
.reg .f64 fd<761>;
.reg .b64 rd<9>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 12;
mov.u32 r3, %32;
add.s32 r4, r3, r2;
add.f64 fd65, %34, %50;
sub.f64 fd67, %34, %50;
add.f64 fd754, %35, %66;
sub.f64 fd68, %35, %66;
add.f64 fd69, %42, %58;
sub.f64 fd71, %42, %58;
add.f64 fd752, %67, %59;
sub.f64 fd72, %67, %59;
add.f64 fd73, fd65, fd69;
sub.f64 fd75, fd65, fd69;
add.f64 fd751, fd754, fd752;
sub.f64 fd76, fd754, fd752;
add.f64 fd77, fd67, fd72;
sub.f64 fd79, fd67, fd72;
sub.f64 fd750, fd68, fd71;
add.f64 fd80, fd68, fd71;
add.f64 fd81, %38, %54;
sub.f64 fd83, %38, %54;
add.f64 fd747, %69, %68;
sub.f64 fd84, %69, %68;
add.f64 fd85, %46, %62;
sub.f64 fd87, %46, %62;
add.f64 fd745, %47, %70;
sub.f64 fd88, %47, %70;
add.f64 fd89, fd81, fd85;
sub.f64 fd91, fd81, fd85;
add.f64 fd744, fd747, fd745;
sub.f64 fd92, fd747, fd745;
add.f64 fd93, fd83, fd88;
sub.f64 fd95, fd83, fd88;
sub.f64 fd743, fd84, fd87;
add.f64 fd96, fd84, fd87;
mul.f64 fd98, fd743, 0dBFE6A09E667F3BCD;
mul.f64 fd742, fd93, 0d3FE6A09E667F3BCD;
sub.f64 fd99, fd742, fd98;
mul.f64 fd100, fd743, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd101, fd93, 0dBFE6A09E667F3BCD, fd100;
mul.f64 fd102, fd95, 0dBFE6A09E667F3BCD;
mul.f64 fd103, fd96, 0dBFE6A09E667F3BCD;
sub.f64 fd104, fd102, fd103;
add.f64 fd105, fd102, fd103;
add.f64 fd106, fd73, fd89;
sub.f64 fd108, fd73, fd89;
add.f64 fd741, fd751, fd744;
sub.f64 fd109, fd751, fd744;
add.f64 fd110, fd77, fd99;
sub.f64 fd112, fd77, fd99;
add.f64 fd740, fd750, fd101;
sub.f64 fd113, fd750, fd101;
add.f64 fd114, fd75, fd92;
sub.f64 fd116, fd75, fd92;
sub.f64 fd739, fd76, fd91;
add.f64 fd117, fd76, fd91;
add.f64 fd118, fd79, fd104;
sub.f64 fd120, fd79, fd104;
add.f64 fd738, fd80, fd105;
sub.f64 fd121, fd80, fd105;
add.f64 fd122, %36, %52;
sub.f64 fd124, %36, %52;
add.f64 fd736, %71, %53;
sub.f64 fd125, %71, %53;
add.f64 fd126, %44, %60;
sub.f64 fd128, %44, %60;
add.f64 fd733, %72, %73;
sub.f64 fd129, %72, %73;
add.f64 fd130, fd122, fd126;
sub.f64 fd132, fd122, fd126;
add.f64 fd732, fd736, fd733;
sub.f64 fd133, fd736, fd733;
add.f64 fd134, fd124, fd129;
sub.f64 fd136, fd124, fd129;
sub.f64 fd731, fd125, fd128;
add.f64 fd137, fd125, fd128;
add.f64 fd138, %40, %56;
sub.f64 fd140, %40, %56;
add.f64 fd729, %41, %74;
sub.f64 fd141, %41, %74;
add.f64 fd142, %48, %64;
sub.f64 fd144, %48, %64;
add.f64 fd727, %75, %65;
sub.f64 fd145, %75, %65;
add.f64 fd146, fd138, fd142;
sub.f64 fd148, fd138, fd142;
add.f64 fd726, fd729, fd727;
sub.f64 fd149, fd729, fd727;
add.f64 fd150, fd140, fd145;
sub.f64 fd152, fd140, fd145;
sub.f64 fd725, fd141, fd144;
add.f64 fd153, fd141, fd144;
mul.f64 fd155, fd725, 0dBFE6A09E667F3BCD;
mul.f64 fd724, fd150, 0d3FE6A09E667F3BCD;
sub.f64 fd156, fd724, fd155;
mul.f64 fd157, fd725, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd158, fd150, 0dBFE6A09E667F3BCD, fd157;
mul.f64 fd159, fd152, 0dBFE6A09E667F3BCD;
mul.f64 fd160, fd153, 0dBFE6A09E667F3BCD;
sub.f64 fd161, fd159, fd160;
add.f64 fd162, fd159, fd160;
add.f64 fd163, fd130, fd146;
sub.f64 fd165, fd130, fd146;
add.f64 fd723, fd732, fd726;
sub.f64 fd166, fd732, fd726;
add.f64 fd167, fd134, fd156;
sub.f64 fd169, fd134, fd156;
add.f64 fd722, fd731, fd158;
sub.f64 fd170, fd731, fd158;
add.f64 fd171, fd132, fd149;
sub.f64 fd173, fd132, fd149;
sub.f64 fd721, fd133, fd148;
add.f64 fd174, fd133, fd148;
add.f64 fd175, fd136, fd161;
sub.f64 fd177, fd136, fd161;
add.f64 fd720, fd137, fd162;
sub.f64 fd178, fd137, fd162;
mul.f64 fd718, fd167, 0d3FED906BCF328D46;
mul.f64 fd719, fd722, 0dBFD87DE2A6AEA963;
sub.f64 fd181, fd718, fd719;
mul.f64 fd182, fd722, 0d3FED906BCF328D46;
fma.rn.f64 fd183, fd167, 0dBFD87DE2A6AEA963, fd182;
mul.f64 fd716, fd171, 0d3FE6A09E667F3BCD;
mul.f64 fd717, fd721, 0dBFE6A09E667F3BCD;
sub.f64 fd186, fd716, fd717;
mul.f64 fd187, fd721, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd188, fd171, 0dBFE6A09E667F3BCD, fd187;
mul.f64 fd714, fd175, 0d3FD87DE2A6AEA963;
mul.f64 fd715, fd720, 0dBFED906BCF328D46;
sub.f64 fd191, fd714, fd715;
mul.f64 fd192, fd720, 0d3FD87DE2A6AEA963;
fma.rn.f64 fd193, fd175, 0dBFED906BCF328D46, fd192;
mul.f64 fd712, fd169, 0dBFD87DE2A6AEA963;
mul.f64 fd713, fd170, 0dBFED906BCF328D46;
sub.f64 fd196, fd712, fd713;
mul.f64 fd197, fd170, 0dBFD87DE2A6AEA963;
fma.rn.f64 fd198, fd169, 0dBFED906BCF328D46, fd197;
mul.f64 fd199, fd173, 0dBFE6A09E667F3BCD;
mul.f64 fd200, fd174, 0dBFE6A09E667F3BCD;
sub.f64 fd201, fd199, fd200;
add.f64 fd202, fd199, fd200;
mul.f64 fd710, fd177, 0dBFED906BCF328D46;
mul.f64 fd711, fd178, 0dBFD87DE2A6AEA963;
sub.f64 fd205, fd710, fd711;
mul.f64 fd206, fd178, 0dBFED906BCF328D46;
fma.rn.f64 fd207, fd177, 0dBFD87DE2A6AEA963, fd206;
add.f64 fd210, fd110, fd181;
sub.f64 fd212, fd110, fd181;
add.f64 fd709, fd740, fd183;
sub.f64 fd213, fd740, fd183;
add.f64 fd214, fd114, fd186;
sub.f64 fd216, fd114, fd186;
add.f64 fd708, fd739, fd188;
sub.f64 fd217, fd739, fd188;
add.f64 fd218, fd118, fd191;
sub.f64 fd220, fd118, fd191;
add.f64 fd707, fd738, fd193;
sub.f64 fd221, fd738, fd193;
add.f64 fd222, fd108, fd166;
sub.f64 fd224, fd108, fd166;
sub.f64 fd706, fd109, fd165;
add.f64 fd225, fd109, fd165;
add.f64 fd226, fd112, fd196;
sub.f64 fd228, fd112, fd196;
add.f64 fd705, fd113, fd198;
sub.f64 fd229, fd113, fd198;
add.f64 fd230, fd116, fd201;
sub.f64 fd232, fd116, fd201;
add.f64 fd704, fd117, fd202;
sub.f64 fd233, fd117, fd202;
add.f64 fd234, fd120, fd205;
sub.f64 fd236, fd120, fd205;
add.f64 fd703, fd121, fd207;
sub.f64 fd237, fd121, fd207;
mov.u32 r15, %tid.x;
shl.b32 r7, r15, 8;
and.b32 r8, r7, -4096;
add.s32 r9, r4, r8;
and.b32 r14, r15, 15;
shl.b32 r10, r15, 4;
cvt.u64.u32 rd2, r10;
and.b64 rd3, rd2, 240;
mov.u64 rd4, %33;
add.s64 rd5, rd4, rd3;
ld.global.v2.f64 {fd238, fd239}, [rd5];
mul.f64 fd243, fd239, fd709;
mul.f64 fd244, fd238, fd709;
mul.f64 fd246, fd239, fd239;
mul.f64 fd702, fd238, fd238;
sub.f64 fd247, fd702, fd246;
mul.f64 fd248, fd239, fd238;
fma.rn.f64 fd249, fd239, fd238, fd248;
mul.f64 fd251, fd249, fd708;
mul.f64 fd252, fd247, fd708;
mul.f64 fd700, fd238, fd247;
mul.f64 fd701, fd239, fd249;
sub.f64 fd255, fd700, fd701;
mul.f64 fd699, fd247, fd214;
mul.f64 fd256, fd238, fd249;
fma.rn.f64 fd257, fd239, fd247, fd256;
mul.f64 fd259, fd257, fd707;
mul.f64 fd260, fd255, fd707;
mul.f64 fd262, fd239, fd257;
mul.f64 fd698, fd238, fd255;
sub.f64 fd263, fd698, fd262;
mul.f64 fd697, fd255, fd218;
mul.f64 fd264, fd238, fd257;
fma.rn.f64 fd265, fd239, fd255, fd264;
mul.f64 fd267, fd265, fd706;
mul.f64 fd268, fd263, fd706;
mul.f64 fd270, fd239, fd265;
mul.f64 fd696, fd238, fd263;
sub.f64 fd271, fd696, fd270;
mul.f64 fd695, fd263, fd222;
mul.f64 fd272, fd238, fd265;
fma.rn.f64 fd273, fd239, fd263, fd272;
mul.f64 fd275, fd273, fd705;
mul.f64 fd276, fd271, fd705;
mul.f64 fd693, fd238, fd271;
mul.f64 fd694, fd239, fd273;
sub.f64 fd279, fd693, fd694;
mul.f64 fd692, fd271, fd226;
mul.f64 fd280, fd238, fd273;
fma.rn.f64 fd281, fd239, fd271, fd280;
mul.f64 fd283, fd281, fd704;
mul.f64 fd284, fd279, fd704;
mul.f64 fd286, fd239, fd281;
mul.f64 fd691, fd238, fd279;
sub.f64 fd287, fd691, fd286;
mul.f64 fd690, fd279, fd230;
mul.f64 fd288, fd238, fd281;
fma.rn.f64 fd289, fd239, fd279, fd288;
mul.f64 fd291, fd289, fd703;
mul.f64 fd292, fd287, fd703;
mul.f64 fd294, fd239, fd289;
mul.f64 fd689, fd238, fd287;
sub.f64 fd295, fd689, fd294;
mul.f64 fd688, fd287, fd234;
mul.f64 fd296, fd238, fd289;
fma.rn.f64 fd297, fd239, fd287, fd296;
sub.f64 fd687, fd741, fd723;
sub.f64 fd686, fd106, fd163;
mul.f64 fd298, fd295, fd686;
mul.f64 fd299, fd297, fd687;
mul.f64 fd300, fd295, fd687;
ld.global.v2.f64 {fd301, fd302}, [rd5+256];
mul.f64 fd306, fd302, fd213;
mul.f64 fd307, fd301, fd213;
mul.f64 fd684, fd238, fd301;
mul.f64 fd685, fd239, fd302;
sub.f64 fd310, fd684, fd685;
mul.f64 fd683, fd301, fd212;
mul.f64 fd311, fd238, fd302;
fma.rn.f64 fd312, fd239, fd301, fd311;
mul.f64 fd314, fd312, fd217;
mul.f64 fd315, fd310, fd217;
mul.f64 fd317, fd239, fd312;
mul.f64 fd682, fd238, fd310;
sub.f64 fd318, fd682, fd317;
mul.f64 fd681, fd310, fd216;
mul.f64 fd319, fd238, fd312;
fma.rn.f64 fd320, fd239, fd310, fd319;
mul.f64 fd322, fd320, fd221;
mul.f64 fd323, fd318, fd221;
mul.f64 fd679, fd238, fd318;
mul.f64 fd680, fd239, fd320;
sub.f64 fd326, fd679, fd680;
mul.f64 fd678, fd318, fd220;
mul.f64 fd327, fd238, fd320;
fma.rn.f64 fd328, fd239, fd318, fd327;
mul.f64 fd330, fd328, fd225;
mul.f64 fd331, fd326, fd225;
mul.f64 fd676, fd238, fd326;
mul.f64 fd677, fd239, fd328;
sub.f64 fd334, fd676, fd677;
mul.f64 fd675, fd326, fd224;
mul.f64 fd335, fd238, fd328;
fma.rn.f64 fd336, fd239, fd326, fd335;
mul.f64 fd338, fd336, fd229;
mul.f64 fd339, fd334, fd229;
mul.f64 fd341, fd239, fd336;
mul.f64 fd674, fd238, fd334;
sub.f64 fd342, fd674, fd341;
mul.f64 fd673, fd334, fd228;
mul.f64 fd343, fd238, fd336;
fma.rn.f64 fd344, fd239, fd334, fd343;
mul.f64 fd346, fd344, fd233;
mul.f64 fd347, fd342, fd233;
mul.f64 fd671, fd238, fd342;
mul.f64 fd672, fd239, fd344;
sub.f64 fd350, fd671, fd672;
mul.f64 fd670, fd238, fd210;
mul.f64 fd351, fd238, fd344;
mul.f64 fd669, fd342, fd232;
fma.rn.f64 fd352, fd239, fd342, fd351;
mul.f64 fd353, fd350, fd236;
mul.f64 fd354, fd352, fd237;
mul.f64 fd355, fd350, fd237;
mov.u32 r17, %tid.x;
and.b32 r16, r17, 15;
sub.f64 fd758, fd741, fd723;
mul.f64 fd757, fd297, fd758;
mov.u32 r23, %tid.x;
shl.b32 r22, r23, 8;
barrier.sync 0;
and.b32 r11, r22, 3840;
add.s32 r12, r9, r11;
sub.f64 fd760, fd741, fd723;
mul.f64 fd759, fd297, fd760;
add.f64 fd356, fd741, fd723;
sub.f64 fd756, fd106, fd163;
add.f64 fd357, fd106, fd163;
st.shared.v2.f64 [r12], {fd357, fd356};
mov.u32 r19, %tid.x;
and.b32 r18, r19, 15;
mov.u32 r21, %tid.x;
and.b32 r20, r21, 15;
fma.rn.f64 fd358, fd239, fd210, fd244;
sub.f64 fd359, fd670, fd243;
st.shared.v2.f64 [r12+16], {fd359, fd358};
fma.rn.f64 fd360, fd249, fd214, fd252;
sub.f64 fd361, fd699, fd251;
st.shared.v2.f64 [r12+32], {fd361, fd360};
fma.rn.f64 fd362, fd257, fd218, fd260;
sub.f64 fd363, fd697, fd259;
st.shared.v2.f64 [r12+48], {fd363, fd362};
sub.f64 fd364, fd695, fd267;
fma.rn.f64 fd365, fd265, fd222, fd268;
st.shared.v2.f64 [r12+64], {fd364, fd365};
fma.rn.f64 fd366, fd273, fd226, fd276;
sub.f64 fd367, fd692, fd275;
st.shared.v2.f64 [r12+80], {fd367, fd366};
fma.rn.f64 fd368, fd281, fd230, fd284;
sub.f64 fd369, fd690, fd283;
st.shared.v2.f64 [r12+96], {fd369, fd368};
fma.rn.f64 fd370, fd289, fd234, fd292;
sub.f64 fd371, fd688, fd291;
st.shared.v2.f64 [r12+112], {fd371, fd370};
fma.rn.f64 fd372, fd297, fd756, fd300;
sub.f64 fd373, fd298, fd759;
st.shared.v2.f64 [r12+128], {fd373, fd372};
fma.rn.f64 fd374, fd302, fd212, fd307;
sub.f64 fd375, fd683, fd306;
st.shared.v2.f64 [r12+144], {fd375, fd374};
fma.rn.f64 fd376, fd312, fd216, fd315;
sub.f64 fd377, fd681, fd314;
st.shared.v2.f64 [r12+160], {fd377, fd376};
fma.rn.f64 fd378, fd320, fd220, fd323;
sub.f64 fd379, fd678, fd322;
st.shared.v2.f64 [r12+176], {fd379, fd378};
sub.f64 fd380, fd675, fd330;
fma.rn.f64 fd381, fd328, fd224, fd331;
st.shared.v2.f64 [r12+192], {fd380, fd381};
fma.rn.f64 fd382, fd336, fd228, fd339;
sub.f64 fd383, fd673, fd338;
st.shared.v2.f64 [r12+208], {fd383, fd382};
fma.rn.f64 fd384, fd344, fd232, fd347;
sub.f64 fd385, fd669, fd346;
st.shared.v2.f64 [r12+224], {fd385, fd384};
fma.rn.f64 fd386, fd352, fd236, fd355;
sub.f64 fd387, fd353, fd354;
st.shared.v2.f64 [r12+240], {fd387, fd386};
barrier.sync 0;
mad.lo.s32 r13, r20, -240, r12;
ld.shared.v2.f64 {fd388, fd389}, [r13];
ld.shared.v2.f64 {fd392, fd393}, [r13+256];
ld.shared.v2.f64 {fd396, fd397}, [r13+512];
ld.shared.v2.f64 {fd400, fd401}, [r13+768];
ld.shared.v2.f64 {fd404, fd405}, [r13+1024];
ld.shared.v2.f64 {fd408, fd409}, [r13+1280];
ld.shared.v2.f64 {fd412, fd413}, [r13+1536];
ld.shared.v2.f64 {fd416, fd417}, [r13+1792];
ld.shared.v2.f64 {fd420, fd421}, [r13+2048];
ld.shared.v2.f64 {fd424, fd425}, [r13+2304];
ld.shared.v2.f64 {fd428, fd429}, [r13+2560];
ld.shared.v2.f64 {fd432, fd433}, [r13+2816];
ld.shared.v2.f64 {fd436, fd437}, [r13+3072];
ld.shared.v2.f64 {fd440, fd441}, [r13+3328];
ld.shared.v2.f64 {fd444, fd445}, [r13+3584];
ld.shared.v2.f64 {fd448, fd449}, [r13+3840];
add.f64 fd452, fd388, fd420;
sub.f64 fd454, fd388, fd420;
add.f64 fd668, fd389, fd421;
sub.f64 fd455, fd389, fd421;
add.f64 fd456, fd404, fd436;
sub.f64 fd458, fd404, fd436;
add.f64 fd667, fd405, fd437;
sub.f64 fd459, fd405, fd437;
add.f64 fd460, fd452, fd456;
sub.f64 fd462, fd452, fd456;
add.f64 fd666, fd668, fd667;
sub.f64 fd463, fd668, fd667;
add.f64 fd464, fd454, fd459;
sub.f64 fd466, fd454, fd459;
sub.f64 fd665, fd455, fd458;
add.f64 fd467, fd455, fd458;
add.f64 fd468, fd396, fd428;
sub.f64 fd470, fd396, fd428;
add.f64 fd664, fd397, fd429;
sub.f64 fd471, fd397, fd429;
add.f64 fd472, fd412, fd444;
sub.f64 fd474, fd412, fd444;
add.f64 fd663, fd413, fd445;
sub.f64 fd475, fd413, fd445;
add.f64 fd476, fd468, fd472;
sub.f64 fd478, fd468, fd472;
add.f64 fd662, fd664, fd663;
sub.f64 fd479, fd664, fd663;
add.f64 fd480, fd470, fd475;
sub.f64 fd482, fd470, fd475;
sub.f64 fd661, fd471, fd474;
add.f64 fd483, fd471, fd474;
mul.f64 fd485, fd661, 0dBFE6A09E667F3BCD;
mul.f64 fd660, fd480, 0d3FE6A09E667F3BCD;
sub.f64 fd486, fd660, fd485;
mul.f64 fd487, fd661, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd488, fd480, 0dBFE6A09E667F3BCD, fd487;
mul.f64 fd489, fd482, 0dBFE6A09E667F3BCD;
mul.f64 fd490, fd483, 0dBFE6A09E667F3BCD;
sub.f64 fd491, fd489, fd490;
add.f64 fd492, fd489, fd490;
add.f64 fd493, fd460, fd476;
sub.f64 fd495, fd460, fd476;
add.f64 fd659, fd666, fd662;
sub.f64 fd496, fd666, fd662;
add.f64 fd497, fd464, fd486;
sub.f64 fd499, fd464, fd486;
add.f64 fd658, fd665, fd488;
sub.f64 fd500, fd665, fd488;
add.f64 fd501, fd462, fd479;
sub.f64 fd503, fd462, fd479;
sub.f64 fd657, fd463, fd478;
add.f64 fd504, fd463, fd478;
add.f64 fd505, fd466, fd491;
sub.f64 fd507, fd466, fd491;
add.f64 fd656, fd467, fd492;
sub.f64 fd508, fd467, fd492;
add.f64 fd509, fd392, fd424;
sub.f64 fd511, fd392, fd424;
add.f64 fd655, fd393, fd425;
sub.f64 fd512, fd393, fd425;
add.f64 fd513, fd408, fd440;
sub.f64 fd515, fd408, fd440;
add.f64 fd654, fd409, fd441;
sub.f64 fd516, fd409, fd441;
add.f64 fd517, fd509, fd513;
sub.f64 fd519, fd509, fd513;
add.f64 fd653, fd655, fd654;
sub.f64 fd520, fd655, fd654;
add.f64 fd521, fd511, fd516;
sub.f64 fd523, fd511, fd516;
sub.f64 fd652, fd512, fd515;
add.f64 fd524, fd512, fd515;
add.f64 fd525, fd400, fd432;
sub.f64 fd527, fd400, fd432;
add.f64 fd651, fd401, fd433;
sub.f64 fd528, fd401, fd433;
add.f64 fd529, fd416, fd448;
sub.f64 fd531, fd416, fd448;
add.f64 fd650, fd417, fd449;
sub.f64 fd532, fd417, fd449;
add.f64 fd533, fd525, fd529;
sub.f64 fd535, fd525, fd529;
add.f64 fd649, fd651, fd650;
sub.f64 fd536, fd651, fd650;
add.f64 fd537, fd527, fd532;
sub.f64 fd539, fd527, fd532;
sub.f64 fd648, fd528, fd531;
add.f64 fd540, fd528, fd531;
mul.f64 fd542, fd648, 0dBFE6A09E667F3BCD;
mul.f64 fd647, fd537, 0d3FE6A09E667F3BCD;
sub.f64 fd543, fd647, fd542;
mul.f64 fd544, fd648, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd545, fd537, 0dBFE6A09E667F3BCD, fd544;
mul.f64 fd546, fd539, 0dBFE6A09E667F3BCD;
mul.f64 fd547, fd540, 0dBFE6A09E667F3BCD;
sub.f64 fd548, fd546, fd547;
add.f64 fd549, fd546, fd547;
add.f64 fd550, fd517, fd533;
sub.f64 fd552, fd517, fd533;
add.f64 fd646, fd653, fd649;
sub.f64 fd553, fd653, fd649;
add.f64 fd554, fd521, fd543;
sub.f64 fd556, fd521, fd543;
add.f64 fd645, fd652, fd545;
sub.f64 fd557, fd652, fd545;
add.f64 fd558, fd519, fd536;
sub.f64 fd560, fd519, fd536;
sub.f64 fd644, fd520, fd535;
add.f64 fd561, fd520, fd535;
add.f64 fd562, fd523, fd548;
sub.f64 fd564, fd523, fd548;
add.f64 fd643, fd524, fd549;
sub.f64 fd565, fd524, fd549;
mul.f64 fd641, fd554, 0d3FED906BCF328D46;
mul.f64 fd642, fd645, 0dBFD87DE2A6AEA963;
sub.f64 fd568, fd641, fd642;
mul.f64 fd569, fd645, 0d3FED906BCF328D46;
fma.rn.f64 fd570, fd554, 0dBFD87DE2A6AEA963, fd569;
mul.f64 fd572, fd644, 0dBFE6A09E667F3BCD;
mul.f64 fd640, fd558, 0d3FE6A09E667F3BCD;
sub.f64 fd573, fd640, fd572;
mul.f64 fd574, fd644, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd575, fd558, 0dBFE6A09E667F3BCD, fd574;
mul.f64 fd577, fd643, 0dBFED906BCF328D46;
mul.f64 fd639, fd562, 0d3FD87DE2A6AEA963;
sub.f64 fd578, fd639, fd577;
mul.f64 fd579, fd643, 0d3FD87DE2A6AEA963;
fma.rn.f64 fd580, fd562, 0dBFED906BCF328D46, fd579;
mul.f64 fd582, fd557, 0dBFED906BCF328D46;
mul.f64 fd638, fd556, 0dBFD87DE2A6AEA963;
sub.f64 fd583, fd638, fd582;
mul.f64 fd584, fd557, 0dBFD87DE2A6AEA963;
fma.rn.f64 fd585, fd556, 0dBFED906BCF328D46, fd584;
mul.f64 fd586, fd560, 0dBFE6A09E667F3BCD;
mul.f64 fd587, fd561, 0dBFE6A09E667F3BCD;
sub.f64 fd588, fd586, fd587;
add.f64 fd589, fd586, fd587;
mul.f64 fd591, fd565, 0dBFD87DE2A6AEA963;
mul.f64 fd637, fd564, 0dBFED906BCF328D46;
sub.f64 fd592, fd637, fd591;
mul.f64 fd593, fd565, 0dBFED906BCF328D46;
fma.rn.f64 fd594, fd564, 0dBFD87DE2A6AEA963, fd593;
add.f64 %0, fd493, fd550;
add.f64 %1, fd659, fd646;
add.f64 %2, fd497, fd568;
add.f64 %3, fd658, fd570;
add.f64 %5, fd657, fd575;
add.f64 %4, fd501, fd573;
add.f64 %7, fd656, fd580;
add.f64 %6, fd505, fd578;
add.f64 %8, fd495, fd553;
sub.f64 %9, fd496, fd552;
add.f64 %10, fd499, fd583;
add.f64 %11, fd500, fd585;
add.f64 %12, fd503, fd588;
add.f64 %13, fd504, fd589;
add.f64 %14, fd507, fd592;
add.f64 %15, fd508, fd594;
sub.f64 %17, fd659, fd646;
sub.f64 %16, fd493, fd550;
sub.f64 %19, fd658, fd570;
sub.f64 %18, fd497, fd568;
sub.f64 %21, fd657, fd575;
sub.f64 %20, fd501, fd573;
sub.f64 %23, fd656, fd580;
sub.f64 %22, fd505, fd578;
add.f64 %25, fd496, fd552;
sub.f64 %24, fd495, fd553;
sub.f64 %27, fd500, fd585;
sub.f64 %26, fd499, fd583;
sub.f64 %29, fd504, fd589;
sub.f64 %28, fd503, fd588;
sub.f64 %31, fd508, fd594;
sub.f64 %30, fd507, fd592;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y), "=d"(rmem[9].x), "=d"(rmem[9].y), "=d"(rmem[10].x), "=d"(rmem[10].y), "=d"(rmem[11].x), "=d"(rmem[11].y), "=d"(rmem[12].x), "=d"(rmem[12].y), "=d"(rmem[13].x), "=d"(rmem[13].y), "=d"(rmem[14].x), "=d"(rmem[14].y), "=d"(rmem[15].x), "=d"(rmem[15].y): "r"(smem), "l"(lut_dp_16_256), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y), "d"(rmem[9].x), "d"(rmem[9].y), "d"(rmem[10].x), "d"(rmem[10].y), "d"(rmem[11].x), "d"(rmem[11].y), "d"(rmem[12].x), "d"(rmem[12].y), "d"(rmem[13].x), "d"(rmem[13].y), "d"(rmem[14].x), "d"(rmem[14].y), "d"(rmem[15].x), "d"(rmem[15].y), "d"(rmem[8].y), "d"(rmem[4].y), "d"(rmem[10].y), "d"(rmem[2].y), "d"(rmem[14].y), "d"(rmem[1].y), "d"(rmem[5].y), "d"(rmem[13].y), "d"(rmem[11].y), "d"(rmem[7].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<462, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<14>;
.reg .f64 fd<595>;
.reg .b64 rd<6>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 11;
mov.u32 r3, %32;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f64 fd65, %34, %55;
add.f64 fd66, %35, %57;
sub.f64 fd67, %34, %55;
sub.f64 fd68, %35, %57;
add.f64 fd69, %44, %66;
add.f64 fd70, %46, %67;
sub.f64 fd71, %44, %66;
sub.f64 fd72, %46, %67;
add.f64 fd73, fd65, fd69;
add.f64 fd74, fd66, fd70;
sub.f64 fd75, fd65, fd69;
sub.f64 fd76, fd66, fd70;
add.f64 fd77, fd67, fd72;
sub.f64 fd78, fd68, fd71;
sub.f64 fd79, fd67, fd72;
add.f64 fd80, fd68, fd71;
add.f64 fd81, %39, %60;
add.f64 fd82, %41, %62;
sub.f64 fd83, %39, %60;
sub.f64 fd84, %41, %62;
add.f64 fd85, %50, %71;
add.f64 fd86, %51, %73;
sub.f64 fd87, %50, %71;
sub.f64 fd88, %51, %73;
add.f64 fd89, fd81, fd85;
add.f64 fd90, fd82, fd86;
sub.f64 fd91, fd81, fd85;
sub.f64 fd92, fd82, fd86;
add.f64 fd93, fd83, fd88;
sub.f64 fd94, fd84, fd87;
sub.f64 fd95, fd83, fd88;
add.f64 fd96, fd84, fd87;
mul.f64 fd97, fd93, 0d3FE6A09E667F3BCD;
mul.f64 fd98, fd94, 0dBFE6A09E667F3BCD;
sub.f64 fd99, fd97, fd98;
mul.f64 fd100, fd94, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd101, fd93, 0dBFE6A09E667F3BCD, fd100;
mul.f64 fd102, fd95, 0dBFE6A09E667F3BCD;
mul.f64 fd103, fd96, 0dBFE6A09E667F3BCD;
sub.f64 fd104, fd102, fd103;
add.f64 fd105, fd102, fd103;
add.f64 fd106, fd73, fd89;
add.f64 fd107, fd74, fd90;
sub.f64 fd108, fd73, fd89;
sub.f64 fd109, fd74, fd90;
add.f64 fd110, fd77, fd99;
add.f64 fd111, fd78, fd101;
sub.f64 fd112, fd77, fd99;
sub.f64 fd113, fd78, fd101;
add.f64 fd114, fd75, fd92;
sub.f64 fd115, fd76, fd91;
sub.f64 fd116, fd75, fd92;
add.f64 fd117, fd76, fd91;
add.f64 fd118, fd79, fd104;
add.f64 fd119, fd80, fd105;
sub.f64 fd120, fd79, fd104;
sub.f64 fd121, fd80, fd105;
add.f64 fd122, %36, %58;
add.f64 fd123, %38, %59;
sub.f64 fd124, %36, %58;
sub.f64 fd125, %38, %59;
add.f64 fd126, %47, %68;
add.f64 fd127, %49, %70;
sub.f64 fd128, %47, %68;
sub.f64 fd129, %49, %70;
add.f64 fd130, fd122, fd126;
add.f64 fd131, fd123, fd127;
sub.f64 fd132, fd122, fd126;
sub.f64 fd133, fd123, fd127;
add.f64 fd134, fd124, fd129;
sub.f64 fd135, fd125, fd128;
sub.f64 fd136, fd124, fd129;
add.f64 fd137, fd125, fd128;
add.f64 fd138, %42, %63;
add.f64 fd139, %43, %65;
sub.f64 fd140, %42, %63;
sub.f64 fd141, %43, %65;
add.f64 fd142, %52, %74;
add.f64 fd143, %54, %75;
sub.f64 fd144, %52, %74;
sub.f64 fd145, %54, %75;
add.f64 fd146, fd138, fd142;
add.f64 fd147, fd139, fd143;
sub.f64 fd148, fd138, fd142;
sub.f64 fd149, fd139, fd143;
add.f64 fd150, fd140, fd145;
sub.f64 fd151, fd141, fd144;
sub.f64 fd152, fd140, fd145;
add.f64 fd153, fd141, fd144;
mul.f64 fd154, fd150, 0d3FE6A09E667F3BCD;
mul.f64 fd155, fd151, 0dBFE6A09E667F3BCD;
sub.f64 fd156, fd154, fd155;
mul.f64 fd157, fd151, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd158, fd150, 0dBFE6A09E667F3BCD, fd157;
mul.f64 fd159, fd152, 0dBFE6A09E667F3BCD;
mul.f64 fd160, fd153, 0dBFE6A09E667F3BCD;
sub.f64 fd161, fd159, fd160;
add.f64 fd162, fd159, fd160;
add.f64 fd163, fd130, fd146;
add.f64 fd164, fd131, fd147;
sub.f64 fd165, fd130, fd146;
sub.f64 fd166, fd131, fd147;
add.f64 fd167, fd134, fd156;
add.f64 fd168, fd135, fd158;
sub.f64 fd169, fd134, fd156;
sub.f64 fd170, fd135, fd158;
add.f64 fd171, fd132, fd149;
sub.f64 fd172, fd133, fd148;
sub.f64 fd173, fd132, fd149;
add.f64 fd174, fd133, fd148;
add.f64 fd175, fd136, fd161;
add.f64 fd176, fd137, fd162;
sub.f64 fd177, fd136, fd161;
sub.f64 fd178, fd137, fd162;
mul.f64 fd179, fd167, 0d3FED906BCF328D46;
mul.f64 fd180, fd168, 0dBFD87DE2A6AEA963;
sub.f64 fd181, fd179, fd180;
mul.f64 fd182, fd168, 0d3FED906BCF328D46;
fma.rn.f64 fd183, fd167, 0dBFD87DE2A6AEA963, fd182;
mul.f64 fd184, fd171, 0d3FE6A09E667F3BCD;
mul.f64 fd185, fd172, 0dBFE6A09E667F3BCD;
sub.f64 fd186, fd184, fd185;
mul.f64 fd187, fd172, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd188, fd171, 0dBFE6A09E667F3BCD, fd187;
mul.f64 fd189, fd175, 0d3FD87DE2A6AEA963;
mul.f64 fd190, fd176, 0dBFED906BCF328D46;
sub.f64 fd191, fd189, fd190;
mul.f64 fd192, fd176, 0d3FD87DE2A6AEA963;
fma.rn.f64 fd193, fd175, 0dBFED906BCF328D46, fd192;
mul.f64 fd194, fd169, 0dBFD87DE2A6AEA963;
mul.f64 fd195, fd170, 0dBFED906BCF328D46;
sub.f64 fd196, fd194, fd195;
mul.f64 fd197, fd170, 0dBFD87DE2A6AEA963;
fma.rn.f64 fd198, fd169, 0dBFED906BCF328D46, fd197;
mul.f64 fd199, fd173, 0dBFE6A09E667F3BCD;
mul.f64 fd200, fd174, 0dBFE6A09E667F3BCD;
sub.f64 fd201, fd199, fd200;
add.f64 fd202, fd199, fd200;
mul.f64 fd203, fd177, 0dBFED906BCF328D46;
mul.f64 fd204, fd178, 0dBFD87DE2A6AEA963;
sub.f64 fd205, fd203, fd204;
mul.f64 fd206, fd178, 0dBFED906BCF328D46;
fma.rn.f64 fd207, fd177, 0dBFD87DE2A6AEA963, fd206;
add.f64 fd208, fd106, fd163;
add.f64 fd209, fd107, fd164;
sub.f64 fd210, fd106, fd163;
sub.f64 fd211, fd107, fd164;
add.f64 fd212, fd110, fd181;
add.f64 fd213, fd111, fd183;
sub.f64 fd214, fd110, fd181;
sub.f64 fd215, fd111, fd183;
add.f64 fd216, fd114, fd186;
add.f64 fd217, fd115, fd188;
sub.f64 fd218, fd114, fd186;
sub.f64 fd219, fd115, fd188;
add.f64 fd220, fd118, fd191;
add.f64 fd221, fd119, fd193;
sub.f64 fd222, fd118, fd191;
sub.f64 fd223, fd119, fd193;
add.f64 fd224, fd108, fd166;
sub.f64 fd225, fd109, fd165;
sub.f64 fd226, fd108, fd166;
add.f64 fd227, fd109, fd165;
add.f64 fd228, fd112, fd196;
add.f64 fd229, fd113, fd198;
sub.f64 fd230, fd112, fd196;
sub.f64 fd231, fd113, fd198;
add.f64 fd232, fd116, fd201;
add.f64 fd233, fd117, fd202;
sub.f64 fd234, fd116, fd201;
sub.f64 fd235, fd117, fd202;
add.f64 fd236, fd120, fd205;
add.f64 fd237, fd121, fd207;
sub.f64 fd238, fd120, fd205;
sub.f64 fd239, fd121, fd207;
and.b32 r6, r5, 15;
shl.b32 r7, r5, 4;
cvt.u64.u32 rd2, r7;
and.b64 rd3, rd2, 240;
mov.u64 rd4, %33;
add.s64 rd5, rd4, rd3;
ld.global.v2.f64 {fd240, fd241}, [rd5];
mul.f64 fd244, fd240, fd212;
mul.f64 fd245, fd241, fd213;
sub.f64 fd246, fd244, fd245;
mul.f64 fd247, fd240, fd213;
fma.rn.f64 fd248, fd241, fd212, fd247;
mul.f64 fd249, fd240, fd240;
mul.f64 fd250, fd241, fd241;
sub.f64 fd251, fd249, fd250;
mul.f64 fd252, fd241, fd240;
fma.rn.f64 fd253, fd241, fd240, fd252;
mul.f64 fd254, fd251, fd216;
mul.f64 fd255, fd253, fd217;
sub.f64 fd256, fd254, fd255;
mul.f64 fd257, fd251, fd217;
fma.rn.f64 fd258, fd253, fd216, fd257;
mul.f64 fd259, fd240, fd251;
mul.f64 fd260, fd241, fd253;
sub.f64 fd261, fd259, fd260;
mul.f64 fd262, fd240, fd253;
fma.rn.f64 fd263, fd241, fd251, fd262;
mul.f64 fd264, fd261, fd220;
mul.f64 fd265, fd263, fd221;
sub.f64 fd266, fd264, fd265;
mul.f64 fd267, fd261, fd221;
fma.rn.f64 fd268, fd263, fd220, fd267;
mul.f64 fd269, fd240, fd261;
mul.f64 fd270, fd241, fd263;
sub.f64 fd271, fd269, fd270;
mul.f64 fd272, fd240, fd263;
fma.rn.f64 fd273, fd241, fd261, fd272;
mul.f64 fd274, fd271, fd224;
mul.f64 fd275, fd273, fd225;
sub.f64 fd276, fd274, fd275;
mul.f64 fd277, fd271, fd225;
fma.rn.f64 fd278, fd273, fd224, fd277;
mul.f64 fd279, fd240, fd271;
mul.f64 fd280, fd241, fd273;
sub.f64 fd281, fd279, fd280;
mul.f64 fd282, fd240, fd273;
fma.rn.f64 fd283, fd241, fd271, fd282;
mul.f64 fd284, fd281, fd228;
mul.f64 fd285, fd283, fd229;
sub.f64 fd286, fd284, fd285;
mul.f64 fd287, fd281, fd229;
fma.rn.f64 fd288, fd283, fd228, fd287;
mul.f64 fd289, fd240, fd281;
mul.f64 fd290, fd241, fd283;
sub.f64 fd291, fd289, fd290;
mul.f64 fd292, fd240, fd283;
fma.rn.f64 fd293, fd241, fd281, fd292;
mul.f64 fd294, fd291, fd232;
mul.f64 fd295, fd293, fd233;
sub.f64 fd296, fd294, fd295;
mul.f64 fd297, fd291, fd233;
fma.rn.f64 fd298, fd293, fd232, fd297;
mul.f64 fd299, fd240, fd291;
mul.f64 fd300, fd241, fd293;
sub.f64 fd301, fd299, fd300;
mul.f64 fd302, fd240, fd293;
fma.rn.f64 fd303, fd241, fd291, fd302;
mul.f64 fd304, fd301, fd236;
mul.f64 fd305, fd303, fd237;
sub.f64 fd306, fd304, fd305;
mul.f64 fd307, fd301, fd237;
fma.rn.f64 fd308, fd303, fd236, fd307;
mul.f64 fd309, fd240, fd301;
mul.f64 fd310, fd241, fd303;
sub.f64 fd311, fd309, fd310;
mul.f64 fd312, fd240, fd303;
fma.rn.f64 fd313, fd241, fd301, fd312;
mul.f64 fd314, fd311, fd210;
mul.f64 fd315, fd313, fd211;
sub.f64 fd316, fd314, fd315;
mul.f64 fd317, fd311, fd211;
fma.rn.f64 fd318, fd313, fd210, fd317;
ld.global.v2.f64 {fd319, fd320}, [rd5+256];
mul.f64 fd323, fd319, fd214;
mul.f64 fd324, fd320, fd215;
sub.f64 fd325, fd323, fd324;
mul.f64 fd326, fd319, fd215;
fma.rn.f64 fd327, fd320, fd214, fd326;
mul.f64 fd328, fd240, fd319;
mul.f64 fd329, fd241, fd320;
sub.f64 fd330, fd328, fd329;
mul.f64 fd331, fd240, fd320;
fma.rn.f64 fd332, fd241, fd319, fd331;
mul.f64 fd333, fd330, fd218;
mul.f64 fd334, fd332, fd219;
sub.f64 fd335, fd333, fd334;
mul.f64 fd336, fd330, fd219;
fma.rn.f64 fd337, fd332, fd218, fd336;
mul.f64 fd338, fd240, fd330;
mul.f64 fd339, fd241, fd332;
sub.f64 fd340, fd338, fd339;
mul.f64 fd341, fd240, fd332;
fma.rn.f64 fd342, fd241, fd330, fd341;
mul.f64 fd343, fd340, fd222;
mul.f64 fd344, fd342, fd223;
sub.f64 fd345, fd343, fd344;
mul.f64 fd346, fd340, fd223;
fma.rn.f64 fd347, fd342, fd222, fd346;
mul.f64 fd348, fd240, fd340;
mul.f64 fd349, fd241, fd342;
sub.f64 fd350, fd348, fd349;
mul.f64 fd351, fd240, fd342;
fma.rn.f64 fd352, fd241, fd340, fd351;
mul.f64 fd353, fd350, fd226;
mul.f64 fd354, fd352, fd227;
sub.f64 fd355, fd353, fd354;
mul.f64 fd356, fd350, fd227;
fma.rn.f64 fd357, fd352, fd226, fd356;
mul.f64 fd358, fd240, fd350;
mul.f64 fd359, fd241, fd352;
sub.f64 fd360, fd358, fd359;
mul.f64 fd361, fd240, fd352;
fma.rn.f64 fd362, fd241, fd350, fd361;
mul.f64 fd363, fd360, fd230;
mul.f64 fd364, fd362, fd231;
sub.f64 fd365, fd363, fd364;
mul.f64 fd366, fd360, fd231;
fma.rn.f64 fd367, fd362, fd230, fd366;
mul.f64 fd368, fd240, fd360;
mul.f64 fd369, fd241, fd362;
sub.f64 fd370, fd368, fd369;
mul.f64 fd371, fd240, fd362;
fma.rn.f64 fd372, fd241, fd360, fd371;
mul.f64 fd373, fd370, fd234;
mul.f64 fd374, fd372, fd235;
sub.f64 fd375, fd373, fd374;
mul.f64 fd376, fd370, fd235;
fma.rn.f64 fd377, fd372, fd234, fd376;
mul.f64 fd378, fd240, fd370;
mul.f64 fd379, fd241, fd372;
sub.f64 fd380, fd378, fd379;
mul.f64 fd381, fd240, fd372;
fma.rn.f64 fd382, fd241, fd370, fd381;
mul.f64 fd383, fd380, fd238;
mul.f64 fd384, fd382, fd239;
sub.f64 fd385, fd383, fd384;
mul.f64 fd386, fd380, fd239;
fma.rn.f64 fd387, fd382, fd238, fd386;
shl.b32 r8, r5, 7;
and.b32 r9, r8, -2048;
add.s32 r10, r4, r9;
barrier.sync 0;
and.b32 r11, r8, 1920;
add.s32 r12, r10, r11;
st.shared.v2.f64 [r12], {fd208, fd246};
st.shared.v2.f64 [r12+16], {fd256, fd266};
st.shared.v2.f64 [r12+32], {fd276, fd286};
st.shared.v2.f64 [r12+48], {fd296, fd306};
st.shared.v2.f64 [r12+64], {fd316, fd325};
st.shared.v2.f64 [r12+80], {fd335, fd345};
st.shared.v2.f64 [r12+96], {fd355, fd365};
st.shared.v2.f64 [r12+112], {fd375, fd385};
barrier.sync 0;
mad.lo.s32 r13, r6, -120, r12;
ld.shared.f64 fd388, [r13];
ld.shared.f64 fd389, [r13+128];
ld.shared.f64 fd390, [r13+256];
ld.shared.f64 fd391, [r13+384];
ld.shared.f64 fd392, [r13+512];
ld.shared.f64 fd393, [r13+640];
ld.shared.f64 fd394, [r13+768];
ld.shared.f64 fd395, [r13+896];
ld.shared.f64 fd396, [r13+1024];
ld.shared.f64 fd397, [r13+1152];
ld.shared.f64 fd398, [r13+1280];
ld.shared.f64 fd399, [r13+1408];
ld.shared.f64 fd400, [r13+1536];
ld.shared.f64 fd401, [r13+1664];
ld.shared.f64 fd402, [r13+1792];
ld.shared.f64 fd403, [r13+1920];
barrier.sync 0;
st.shared.v2.f64 [r12], {fd209, fd248};
st.shared.v2.f64 [r12+16], {fd258, fd268};
st.shared.v2.f64 [r12+32], {fd278, fd288};
st.shared.v2.f64 [r12+48], {fd298, fd308};
st.shared.v2.f64 [r12+64], {fd318, fd327};
st.shared.v2.f64 [r12+80], {fd337, fd347};
st.shared.v2.f64 [r12+96], {fd357, fd367};
st.shared.v2.f64 [r12+112], {fd377, fd387};
barrier.sync 0;
ld.shared.f64 fd404, [r13];
ld.shared.f64 fd405, [r13+128];
ld.shared.f64 fd406, [r13+256];
ld.shared.f64 fd407, [r13+384];
ld.shared.f64 fd408, [r13+512];
ld.shared.f64 fd409, [r13+640];
ld.shared.f64 fd410, [r13+768];
ld.shared.f64 fd411, [r13+896];
ld.shared.f64 fd412, [r13+1024];
ld.shared.f64 fd413, [r13+1152];
ld.shared.f64 fd414, [r13+1280];
ld.shared.f64 fd415, [r13+1408];
ld.shared.f64 fd416, [r13+1536];
ld.shared.f64 fd417, [r13+1664];
ld.shared.f64 fd418, [r13+1792];
ld.shared.f64 fd419, [r13+1920];
add.f64 fd420, fd388, fd396;
add.f64 fd421, fd404, fd412;
sub.f64 fd422, fd388, fd396;
sub.f64 fd423, fd404, fd412;
add.f64 fd424, fd392, fd400;
add.f64 fd425, fd408, fd416;
sub.f64 fd426, fd392, fd400;
sub.f64 fd427, fd408, fd416;
add.f64 fd428, fd420, fd424;
add.f64 fd429, fd421, fd425;
sub.f64 fd430, fd420, fd424;
sub.f64 fd431, fd421, fd425;
add.f64 fd432, fd422, fd427;
sub.f64 fd433, fd423, fd426;
sub.f64 fd434, fd422, fd427;
add.f64 fd435, fd423, fd426;
add.f64 fd436, fd390, fd398;
add.f64 fd437, fd406, fd414;
sub.f64 fd438, fd390, fd398;
sub.f64 fd439, fd406, fd414;
add.f64 fd440, fd394, fd402;
add.f64 fd441, fd410, fd418;
sub.f64 fd442, fd394, fd402;
sub.f64 fd443, fd410, fd418;
add.f64 fd444, fd436, fd440;
add.f64 fd445, fd437, fd441;
sub.f64 fd446, fd436, fd440;
sub.f64 fd447, fd437, fd441;
add.f64 fd448, fd438, fd443;
sub.f64 fd449, fd439, fd442;
sub.f64 fd450, fd438, fd443;
add.f64 fd451, fd439, fd442;
mul.f64 fd452, fd448, 0d3FE6A09E667F3BCD;
mul.f64 fd453, fd449, 0dBFE6A09E667F3BCD;
sub.f64 fd454, fd452, fd453;
mul.f64 fd455, fd449, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd456, fd448, 0dBFE6A09E667F3BCD, fd455;
mul.f64 fd457, fd450, 0dBFE6A09E667F3BCD;
mul.f64 fd458, fd451, 0dBFE6A09E667F3BCD;
sub.f64 fd459, fd457, fd458;
add.f64 fd460, fd457, fd458;
add.f64 fd461, fd428, fd444;
add.f64 fd462, fd429, fd445;
sub.f64 fd463, fd428, fd444;
sub.f64 fd464, fd429, fd445;
add.f64 fd465, fd432, fd454;
add.f64 fd466, fd433, fd456;
sub.f64 fd467, fd432, fd454;
sub.f64 fd468, fd433, fd456;
add.f64 fd469, fd430, fd447;
sub.f64 fd470, fd431, fd446;
sub.f64 fd471, fd430, fd447;
add.f64 fd472, fd431, fd446;
add.f64 fd473, fd434, fd459;
add.f64 fd474, fd435, fd460;
sub.f64 fd475, fd434, fd459;
sub.f64 fd476, fd435, fd460;
add.f64 fd477, fd389, fd397;
add.f64 fd478, fd405, fd413;
sub.f64 fd479, fd389, fd397;
sub.f64 fd480, fd405, fd413;
add.f64 fd481, fd393, fd401;
add.f64 fd482, fd409, fd417;
sub.f64 fd483, fd393, fd401;
sub.f64 fd484, fd409, fd417;
add.f64 fd485, fd477, fd481;
add.f64 fd486, fd478, fd482;
sub.f64 fd487, fd477, fd481;
sub.f64 fd488, fd478, fd482;
add.f64 fd489, fd479, fd484;
sub.f64 fd490, fd480, fd483;
sub.f64 fd491, fd479, fd484;
add.f64 fd492, fd480, fd483;
add.f64 fd493, fd391, fd399;
add.f64 fd494, fd407, fd415;
sub.f64 fd495, fd391, fd399;
sub.f64 fd496, fd407, fd415;
add.f64 fd497, fd395, fd403;
add.f64 fd498, fd411, fd419;
sub.f64 fd499, fd395, fd403;
sub.f64 fd500, fd411, fd419;
add.f64 fd501, fd493, fd497;
add.f64 fd502, fd494, fd498;
sub.f64 fd503, fd493, fd497;
sub.f64 fd504, fd494, fd498;
add.f64 fd505, fd495, fd500;
sub.f64 fd506, fd496, fd499;
sub.f64 fd507, fd495, fd500;
add.f64 fd508, fd496, fd499;
mul.f64 fd509, fd505, 0d3FE6A09E667F3BCD;
mul.f64 fd510, fd506, 0dBFE6A09E667F3BCD;
sub.f64 fd511, fd509, fd510;
mul.f64 fd512, fd506, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd513, fd505, 0dBFE6A09E667F3BCD, fd512;
mul.f64 fd514, fd507, 0dBFE6A09E667F3BCD;
mul.f64 fd515, fd508, 0dBFE6A09E667F3BCD;
sub.f64 fd516, fd514, fd515;
add.f64 fd517, fd514, fd515;
add.f64 fd518, fd485, fd501;
add.f64 fd519, fd486, fd502;
sub.f64 fd520, fd485, fd501;
sub.f64 fd521, fd486, fd502;
add.f64 fd522, fd489, fd511;
add.f64 fd523, fd490, fd513;
sub.f64 fd524, fd489, fd511;
sub.f64 fd525, fd490, fd513;
add.f64 fd526, fd487, fd504;
sub.f64 fd527, fd488, fd503;
sub.f64 fd528, fd487, fd504;
add.f64 fd529, fd488, fd503;
add.f64 fd530, fd491, fd516;
add.f64 fd531, fd492, fd517;
sub.f64 fd532, fd491, fd516;
sub.f64 fd533, fd492, fd517;
mul.f64 fd534, fd522, 0d3FED906BCF328D46;
mul.f64 fd535, fd523, 0dBFD87DE2A6AEA963;
sub.f64 fd536, fd534, fd535;
mul.f64 fd537, fd523, 0d3FED906BCF328D46;
fma.rn.f64 fd538, fd522, 0dBFD87DE2A6AEA963, fd537;
mul.f64 fd539, fd526, 0d3FE6A09E667F3BCD;
mul.f64 fd540, fd527, 0dBFE6A09E667F3BCD;
sub.f64 fd541, fd539, fd540;
mul.f64 fd542, fd527, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd543, fd526, 0dBFE6A09E667F3BCD, fd542;
mul.f64 fd544, fd530, 0d3FD87DE2A6AEA963;
mul.f64 fd545, fd531, 0dBFED906BCF328D46;
sub.f64 fd546, fd544, fd545;
mul.f64 fd547, fd531, 0d3FD87DE2A6AEA963;
fma.rn.f64 fd548, fd530, 0dBFED906BCF328D46, fd547;
mul.f64 fd549, fd524, 0dBFD87DE2A6AEA963;
mul.f64 fd550, fd525, 0dBFED906BCF328D46;
sub.f64 fd551, fd549, fd550;
mul.f64 fd552, fd525, 0dBFD87DE2A6AEA963;
fma.rn.f64 fd553, fd524, 0dBFED906BCF328D46, fd552;
mul.f64 fd554, fd528, 0dBFE6A09E667F3BCD;
mul.f64 fd555, fd529, 0dBFE6A09E667F3BCD;
sub.f64 fd556, fd554, fd555;
add.f64 fd557, fd554, fd555;
mul.f64 fd558, fd532, 0dBFED906BCF328D46;
mul.f64 fd559, fd533, 0dBFD87DE2A6AEA963;
sub.f64 fd560, fd558, fd559;
mul.f64 fd561, fd533, 0dBFED906BCF328D46;
fma.rn.f64 fd562, fd532, 0dBFD87DE2A6AEA963, fd561;
add.f64 %0, fd461, fd518;
add.f64 %1, fd462, fd519;
add.f64 %3, fd466, fd538;
add.f64 %2, fd465, fd536;
add.f64 %5, fd470, fd543;
add.f64 %4, fd469, fd541;
add.f64 %7, fd474, fd548;
add.f64 %6, fd473, fd546;
sub.f64 %9, fd464, fd520;
add.f64 %8, fd463, fd521;
add.f64 %11, fd468, fd553;
add.f64 %10, fd467, fd551;
add.f64 %13, fd472, fd557;
add.f64 %12, fd471, fd556;
add.f64 %15, fd476, fd562;
add.f64 %14, fd475, fd560;
sub.f64 %16, fd461, fd518;
sub.f64 %17, fd462, fd519;
sub.f64 %19, fd466, fd538;
sub.f64 %18, fd465, fd536;
sub.f64 %21, fd470, fd543;
sub.f64 %20, fd469, fd541;
sub.f64 %23, fd474, fd548;
sub.f64 %22, fd473, fd546;
add.f64 %25, fd464, fd520;
sub.f64 %24, fd463, fd521;
sub.f64 %27, fd468, fd553;
sub.f64 %26, fd467, fd551;
sub.f64 %29, fd472, fd557;
sub.f64 %28, fd471, fd556;
sub.f64 %31, fd476, fd562;
sub.f64 %30, fd475, fd560;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y), "=d"(rmem[9].x), "=d"(rmem[9].y), "=d"(rmem[10].x), "=d"(rmem[10].y), "=d"(rmem[11].x), "=d"(rmem[11].y), "=d"(rmem[12].x), "=d"(rmem[12].y), "=d"(rmem[13].x), "=d"(rmem[13].y), "=d"(rmem[14].x), "=d"(rmem[14].y), "=d"(rmem[15].x), "=d"(rmem[15].y): "r"(smem), "l"(lut_dp_16_256), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y), "d"(rmem[8].y), "d"(rmem[9].x), "d"(rmem[9].y), "d"(rmem[10].x), "d"(rmem[10].y), "d"(rmem[10].y), "d"(rmem[11].x), "d"(rmem[11].y), "d"(rmem[11].y), "d"(rmem[12].x), "d"(rmem[12].y), "d"(rmem[13].x), "d"(rmem[13].y), "d"(rmem[13].y), "d"(rmem[14].x), "d"(rmem[14].y), "d"(rmem[14].y), "d"(rmem[15].x), "d"(rmem[15].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<463, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<27>;
.reg .f64 fd<213>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 12;
mov.u32 r3, %8;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f64 fd17, %12, %17;
add.f64 fd18, %13, %19;
sub.f64 fd19, %12, %17;
sub.f64 fd20, %13, %19;
add.f64 fd21, %14, %20;
add.f64 fd22, %16, %21;
sub.f64 fd23, %14, %20;
sub.f64 fd24, %16, %21;
sub.f64 fd25, fd17, fd21;
sub.f64 fd26, fd18, fd22;
add.f64 fd27, fd19, fd24;
sub.f64 fd28, fd20, fd23;
sub.f64 fd29, fd19, fd24;
add.f64 fd30, fd20, fd23;
and.b32 r6, r5, 63;
shl.b32 r7, r5, 6;
and.b32 r8, r7, -4096;
add.s32 r9, r4, r8;
shl.b32 r10, r5, 4;
cvt.u64.u32 rd2, r10;
and.b64 rd3, rd2, 1008;
mov.u64 rd4, %9;
add.s64 rd5, rd4, rd3;
ld.global.v2.f64 {fd31, fd32}, [rd5];
mul.f64 fd35, fd31, fd27;
mul.f64 fd36, fd32, fd28;
mul.f64 fd37, fd31, fd28;
mul.f64 fd38, fd31, fd31;
mul.f64 fd39, fd32, fd32;
sub.f64 fd40, fd38, fd39;
mul.f64 fd41, fd32, fd31;
fma.rn.f64 fd42, fd32, fd31, fd41;
mul.f64 fd43, fd40, fd25;
mul.f64 fd44, fd42, fd26;
mul.f64 fd45, fd40, fd26;
ld.global.v2.f64 {fd46, fd47}, [rd5+1024];
mul.f64 fd50, fd46, fd29;
mul.f64 fd51, fd47, fd30;
mul.f64 fd52, fd46, fd30;
barrier.sync 0;
and.b32 r11, r7, 4032;
add.s32 r12, r9, r11;
add.f64 fd53, fd18, fd22;
add.f64 fd54, fd17, fd21;
st.shared.v2.f64 [r12], {fd54, fd53};
fma.rn.f64 fd55, fd32, fd27, fd37;
sub.f64 fd56, fd35, fd36;
st.shared.v2.f64 [r12+16], {fd56, fd55};
sub.f64 fd57, fd43, fd44;
fma.rn.f64 fd58, fd42, fd25, fd45;
st.shared.v2.f64 [r12+32], {fd57, fd58};
fma.rn.f64 fd59, fd47, fd29, fd52;
sub.f64 fd60, fd50, fd51;
st.shared.v2.f64 [r12+48], {fd60, fd59};
barrier.sync 0;
mad.lo.s32 r13, r6, -48, r12;
ld.shared.v2.f64 {fd61, fd62}, [r13];
ld.shared.v2.f64 {fd65, fd66}, [r13+1024];
ld.shared.v2.f64 {fd69, fd70}, [r13+2048];
ld.shared.v2.f64 {fd73, fd74}, [r13+3072];
add.f64 fd77, fd61, fd69;
add.f64 fd78, fd62, fd70;
sub.f64 fd79, fd61, fd69;
sub.f64 fd80, fd62, fd70;
add.f64 fd81, fd65, fd73;
add.f64 fd82, fd66, fd74;
sub.f64 fd83, fd65, fd73;
sub.f64 fd84, fd66, fd74;
sub.f64 fd85, fd77, fd81;
sub.f64 fd86, fd78, fd82;
add.f64 fd87, fd79, fd84;
sub.f64 fd88, fd80, fd83;
sub.f64 fd89, fd79, fd84;
add.f64 fd90, fd80, fd83;
and.b32 r14, r5, 60;
bfe.u32 r15, r5, 2, 4;
mul.wide.u32 rd6, r15, 16;
mov.u64 rd7, %10;
add.s64 rd8, rd7, rd6;
ld.global.v2.f64 {fd91, fd92}, [rd8];
mul.f64 fd95, fd91, fd87;
mul.f64 fd96, fd92, fd88;
mul.f64 fd97, fd91, fd88;
mul.f64 fd98, fd91, fd91;
mul.f64 fd99, fd92, fd92;
sub.f64 fd100, fd98, fd99;
mul.f64 fd101, fd92, fd91;
fma.rn.f64 fd102, fd92, fd91, fd101;
mul.f64 fd103, fd100, fd85;
mul.f64 fd104, fd102, fd86;
mul.f64 fd105, fd100, fd86;
ld.global.v2.f64 {fd106, fd107}, [rd8+256];
mul.f64 fd110, fd106, fd89;
mul.f64 fd111, fd107, fd90;
mul.f64 fd112, fd106, fd90;
and.b32 r16, r10, 48;
add.s32 r17, r9, r16;
barrier.sync 0;
and.b32 r18, r7, 3840;
add.s32 r19, r17, r18;
add.f64 fd113, fd78, fd82;
add.f64 fd114, fd77, fd81;
st.shared.v2.f64 [r19], {fd114, fd113};
fma.rn.f64 fd115, fd92, fd87, fd97;
sub.f64 fd116, fd95, fd96;
st.shared.v2.f64 [r19+64], {fd116, fd115};
fma.rn.f64 fd117, fd102, fd85, fd105;
sub.f64 fd118, fd103, fd104;
st.shared.v2.f64 [r19+128], {fd118, fd117};
fma.rn.f64 fd119, fd107, fd89, fd112;
sub.f64 fd120, fd110, fd111;
st.shared.v2.f64 [r19+192], {fd120, fd119};
barrier.sync 0;
mad.lo.s32 r20, r14, -48, r19;
ld.shared.v2.f64 {fd121, fd122}, [r20];
ld.shared.v2.f64 {fd125, fd126}, [r20+1024];
ld.shared.v2.f64 {fd129, fd130}, [r20+2048];
ld.shared.v2.f64 {fd133, fd134}, [r20+3072];
add.f64 fd137, fd121, fd129;
add.f64 fd138, fd122, fd130;
sub.f64 fd139, fd121, fd129;
sub.f64 fd140, fd122, fd130;
add.f64 fd141, fd125, fd133;
add.f64 fd142, fd126, fd134;
sub.f64 fd143, fd125, fd133;
sub.f64 fd144, fd126, fd134;
sub.f64 fd145, fd137, fd141;
sub.f64 fd146, fd138, fd142;
add.f64 fd147, fd139, fd144;
sub.f64 fd148, fd140, fd143;
sub.f64 fd149, fd139, fd144;
add.f64 fd150, fd140, fd143;
and.b32 r21, r5, 48;
cvt.u64.u32 rd9, r21;
mov.u64 rd10, %11;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd151, fd152}, [rd11];
mul.f64 fd155, fd151, fd147;
mul.f64 fd156, fd152, fd148;
mul.f64 fd157, fd151, fd148;
mul.f64 fd158, fd151, fd151;
mul.f64 fd159, fd152, fd152;
sub.f64 fd160, fd158, fd159;
mul.f64 fd161, fd152, fd151;
fma.rn.f64 fd162, fd152, fd151, fd161;
mul.f64 fd163, fd160, fd145;
mul.f64 fd164, fd162, fd146;
mul.f64 fd165, fd160, fd146;
ld.global.v2.f64 {fd166, fd167}, [rd11+64];
mul.f64 fd170, fd166, fd149;
mul.f64 fd171, fd167, fd150;
mul.f64 fd172, fd166, fd150;
and.b32 r22, r10, 240;
add.s32 r23, r9, r22;
barrier.sync 0;
and.b32 r24, r7, 3072;
add.s32 r25, r23, r24;
add.f64 fd173, fd138, fd142;
add.f64 fd174, fd137, fd141;
st.shared.v2.f64 [r25], {fd174, fd173};
fma.rn.f64 fd175, fd152, fd147, fd157;
sub.f64 fd176, fd155, fd156;
st.shared.v2.f64 [r25+256], {fd176, fd175};
fma.rn.f64 fd177, fd162, fd145, fd165;
sub.f64 fd178, fd163, fd164;
st.shared.v2.f64 [r25+512], {fd178, fd177};
fma.rn.f64 fd179, fd167, fd149, fd172;
sub.f64 fd180, fd170, fd171;
st.shared.v2.f64 [r25+768], {fd180, fd179};
barrier.sync 0;
mad.lo.s32 r26, r21, -48, r25;
ld.shared.v2.f64 {fd181, fd182}, [r26];
ld.shared.v2.f64 {fd185, fd186}, [r26+1024];
ld.shared.v2.f64 {fd189, fd190}, [r26+2048];
ld.shared.v2.f64 {fd193, fd194}, [r26+3072];
add.f64 fd197, fd181, fd189;
add.f64 fd198, fd182, fd190;
sub.f64 fd199, fd181, fd189;
sub.f64 fd200, fd182, fd190;
add.f64 fd201, fd185, fd193;
add.f64 fd202, fd186, fd194;
sub.f64 fd203, fd185, fd193;
sub.f64 fd204, fd186, fd194;
add.f64 %1, fd198, fd202;
add.f64 %0, fd197, fd201;
sub.f64 %3, fd200, fd203;
add.f64 %2, fd199, fd204;
sub.f64 %5, fd198, fd202;
sub.f64 %4, fd197, fd201;
add.f64 %7, fd200, fd203;
sub.f64 %6, fd199, fd204;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y): "r"(smem), "l"(lut_dp_4_256), "l"(lut_dp_4_64), "l"(lut_dp_4_16), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<465, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<21>;
.reg .f64 fd<379>;
.reg .b64 rd<9>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 12;
mov.u32 r3, %16;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f64 fd33, %19, %29;
add.f64 fd34, %20, %31;
sub.f64 fd35, %19, %29;
sub.f64 fd36, %20, %31;
add.f64 fd37, %24, %35;
add.f64 fd38, %26, %36;
sub.f64 fd39, %24, %35;
sub.f64 fd40, %26, %36;
add.f64 fd41, fd33, fd37;
add.f64 fd42, fd34, fd38;
sub.f64 fd43, fd33, fd37;
sub.f64 fd44, fd34, fd38;
add.f64 fd45, fd35, fd40;
sub.f64 fd46, fd36, fd39;
sub.f64 fd47, fd35, fd40;
add.f64 fd48, fd36, fd39;
add.f64 fd49, %21, %32;
add.f64 fd50, %23, %34;
sub.f64 fd51, %21, %32;
sub.f64 fd52, %23, %34;
add.f64 fd53, %27, %37;
add.f64 fd54, %28, %38;
sub.f64 fd55, %27, %37;
sub.f64 fd56, %28, %38;
add.f64 fd57, fd49, fd53;
add.f64 fd58, fd50, fd54;
sub.f64 fd59, fd49, fd53;
sub.f64 fd60, fd50, fd54;
add.f64 fd61, fd51, fd56;
sub.f64 fd62, fd52, fd55;
sub.f64 fd63, fd51, fd56;
add.f64 fd64, fd52, fd55;
mul.f64 fd65, fd61, 0d3FE6A09E667F3BCD;
mul.f64 fd66, fd62, 0dBFE6A09E667F3BCD;
sub.f64 fd67, fd65, fd66;
mul.f64 fd68, fd62, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd69, fd61, 0dBFE6A09E667F3BCD, fd68;
mul.f64 fd70, fd63, 0dBFE6A09E667F3BCD;
mul.f64 fd71, fd64, 0dBFE6A09E667F3BCD;
sub.f64 fd72, fd70, fd71;
add.f64 fd73, fd70, fd71;
sub.f64 fd74, fd41, fd57;
sub.f64 fd75, fd42, fd58;
add.f64 fd76, fd45, fd67;
add.f64 fd77, fd46, fd69;
sub.f64 fd78, fd45, fd67;
sub.f64 fd79, fd46, fd69;
add.f64 fd80, fd43, fd60;
sub.f64 fd81, fd44, fd59;
sub.f64 fd82, fd43, fd60;
add.f64 fd83, fd44, fd59;
add.f64 fd84, fd47, fd72;
add.f64 fd85, fd48, fd73;
sub.f64 fd86, fd47, fd72;
sub.f64 fd87, fd48, fd73;
and.b32 r6, r5, 31;
shl.b32 r7, r5, 7;
and.b32 r8, r7, -4096;
add.s32 r9, r4, r8;
shl.b32 r10, r5, 4;
cvt.u64.u32 rd2, r10;
and.b64 rd3, rd2, 496;
mov.u64 rd4, %17;
add.s64 rd5, rd4, rd3;
ld.global.v2.f64 {fd88, fd89}, [rd5];
mul.f64 fd92, fd88, fd76;
mul.f64 fd93, fd89, fd77;
mul.f64 fd94, fd88, fd77;
mul.f64 fd95, fd88, fd88;
mul.f64 fd96, fd89, fd89;
sub.f64 fd97, fd95, fd96;
mul.f64 fd98, fd89, fd88;
fma.rn.f64 fd99, fd89, fd88, fd98;
mul.f64 fd100, fd97, fd80;
mul.f64 fd101, fd99, fd81;
mul.f64 fd102, fd97, fd81;
mul.f64 fd103, fd88, fd97;
mul.f64 fd104, fd89, fd99;
sub.f64 fd105, fd103, fd104;
mul.f64 fd106, fd88, fd99;
fma.rn.f64 fd107, fd89, fd97, fd106;
mul.f64 fd108, fd105, fd84;
mul.f64 fd109, fd107, fd85;
mul.f64 fd110, fd105, fd85;
mul.f64 fd111, fd88, fd105;
mul.f64 fd112, fd89, fd107;
sub.f64 fd113, fd111, fd112;
mul.f64 fd114, fd88, fd107;
fma.rn.f64 fd115, fd89, fd105, fd114;
mul.f64 fd116, fd113, fd74;
mul.f64 fd117, fd115, fd75;
mul.f64 fd118, fd113, fd75;
ld.global.v2.f64 {fd119, fd120}, [rd5+512];
mul.f64 fd123, fd119, fd78;
mul.f64 fd124, fd120, fd79;
mul.f64 fd125, fd119, fd79;
mul.f64 fd126, fd88, fd119;
mul.f64 fd127, fd89, fd120;
sub.f64 fd128, fd126, fd127;
mul.f64 fd129, fd88, fd120;
fma.rn.f64 fd130, fd89, fd119, fd129;
mul.f64 fd131, fd128, fd82;
mul.f64 fd132, fd130, fd83;
mul.f64 fd133, fd128, fd83;
mul.f64 fd134, fd88, fd128;
mul.f64 fd135, fd89, fd130;
sub.f64 fd136, fd134, fd135;
mul.f64 fd137, fd88, fd130;
fma.rn.f64 fd138, fd89, fd128, fd137;
mul.f64 fd139, fd136, fd86;
mul.f64 fd140, fd138, fd87;
mul.f64 fd141, fd136, fd87;
barrier.sync 0;
and.b32 r11, r7, 3968;
add.s32 r12, r9, r11;
add.f64 fd142, fd42, fd58;
add.f64 fd143, fd41, fd57;
st.shared.v2.f64 [r12], {fd143, fd142};
fma.rn.f64 fd144, fd89, fd76, fd94;
sub.f64 fd145, fd92, fd93;
st.shared.v2.f64 [r12+16], {fd145, fd144};
fma.rn.f64 fd146, fd99, fd80, fd102;
sub.f64 fd147, fd100, fd101;
st.shared.v2.f64 [r12+32], {fd147, fd146};
sub.f64 fd148, fd108, fd109;
fma.rn.f64 fd149, fd107, fd84, fd110;
st.shared.v2.f64 [r12+48], {fd148, fd149};
fma.rn.f64 fd150, fd115, fd74, fd118;
sub.f64 fd151, fd116, fd117;
st.shared.v2.f64 [r12+64], {fd151, fd150};
fma.rn.f64 fd152, fd120, fd78, fd125;
sub.f64 fd153, fd123, fd124;
st.shared.v2.f64 [r12+80], {fd153, fd152};
fma.rn.f64 fd154, fd130, fd82, fd133;
sub.f64 fd155, fd131, fd132;
st.shared.v2.f64 [r12+96], {fd155, fd154};
sub.f64 fd156, fd139, fd140;
fma.rn.f64 fd157, fd138, fd86, fd141;
st.shared.v2.f64 [r12+112], {fd156, fd157};
barrier.sync 0;
mad.lo.s32 r13, r6, -112, r12;
ld.shared.v2.f64 {fd158, fd159}, [r13];
ld.shared.v2.f64 {fd162, fd163}, [r13+512];
ld.shared.v2.f64 {fd166, fd167}, [r13+1024];
ld.shared.v2.f64 {fd170, fd171}, [r13+1536];
ld.shared.v2.f64 {fd174, fd175}, [r13+2048];
ld.shared.v2.f64 {fd178, fd179}, [r13+2560];
ld.shared.v2.f64 {fd182, fd183}, [r13+3072];
ld.shared.v2.f64 {fd186, fd187}, [r13+3584];
add.f64 fd190, fd158, fd174;
add.f64 fd191, fd159, fd175;
sub.f64 fd192, fd158, fd174;
sub.f64 fd193, fd159, fd175;
add.f64 fd194, fd166, fd182;
add.f64 fd195, fd167, fd183;
sub.f64 fd196, fd166, fd182;
sub.f64 fd197, fd167, fd183;
add.f64 fd198, fd190, fd194;
add.f64 fd199, fd191, fd195;
sub.f64 fd200, fd190, fd194;
sub.f64 fd201, fd191, fd195;
add.f64 fd202, fd192, fd197;
sub.f64 fd203, fd193, fd196;
sub.f64 fd204, fd192, fd197;
add.f64 fd205, fd193, fd196;
add.f64 fd206, fd162, fd178;
add.f64 fd207, fd163, fd179;
sub.f64 fd208, fd162, fd178;
sub.f64 fd209, fd163, fd179;
add.f64 fd210, fd170, fd186;
add.f64 fd211, fd171, fd187;
sub.f64 fd212, fd170, fd186;
sub.f64 fd213, fd171, fd187;
add.f64 fd214, fd206, fd210;
add.f64 fd215, fd207, fd211;
sub.f64 fd216, fd206, fd210;
sub.f64 fd217, fd207, fd211;
add.f64 fd218, fd208, fd213;
sub.f64 fd219, fd209, fd212;
sub.f64 fd220, fd208, fd213;
add.f64 fd221, fd209, fd212;
mul.f64 fd222, fd218, 0d3FE6A09E667F3BCD;
mul.f64 fd223, fd219, 0dBFE6A09E667F3BCD;
sub.f64 fd224, fd222, fd223;
mul.f64 fd225, fd219, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd226, fd218, 0dBFE6A09E667F3BCD, fd225;
mul.f64 fd227, fd220, 0dBFE6A09E667F3BCD;
mul.f64 fd228, fd221, 0dBFE6A09E667F3BCD;
sub.f64 fd229, fd227, fd228;
add.f64 fd230, fd227, fd228;
sub.f64 fd231, fd198, fd214;
sub.f64 fd232, fd199, fd215;
add.f64 fd233, fd202, fd224;
add.f64 fd234, fd203, fd226;
sub.f64 fd235, fd202, fd224;
sub.f64 fd236, fd203, fd226;
add.f64 fd237, fd200, fd217;
sub.f64 fd238, fd201, fd216;
sub.f64 fd239, fd200, fd217;
add.f64 fd240, fd201, fd216;
add.f64 fd241, fd204, fd229;
add.f64 fd242, fd205, fd230;
sub.f64 fd243, fd204, fd229;
sub.f64 fd244, fd205, fd230;
and.b32 r14, r5, 24;
bfe.u32 r15, r5, 3, 2;
mul.wide.u32 rd6, r15, 16;
mov.u64 rd7, %18;
add.s64 rd8, rd7, rd6;
ld.global.v2.f64 {fd245, fd246}, [rd8];
mul.f64 fd249, fd245, fd233;
mul.f64 fd250, fd246, fd234;
mul.f64 fd251, fd245, fd234;
mul.f64 fd252, fd245, fd245;
mul.f64 fd253, fd246, fd246;
sub.f64 fd254, fd252, fd253;
mul.f64 fd255, fd246, fd245;
fma.rn.f64 fd256, fd246, fd245, fd255;
mul.f64 fd257, fd254, fd237;
mul.f64 fd258, fd256, fd238;
mul.f64 fd259, fd254, fd238;
mul.f64 fd260, fd245, fd254;
mul.f64 fd261, fd246, fd256;
sub.f64 fd262, fd260, fd261;
mul.f64 fd263, fd245, fd256;
fma.rn.f64 fd264, fd246, fd254, fd263;
mul.f64 fd265, fd262, fd241;
mul.f64 fd266, fd264, fd242;
mul.f64 fd267, fd262, fd242;
mul.f64 fd268, fd245, fd262;
mul.f64 fd269, fd246, fd264;
sub.f64 fd270, fd268, fd269;
mul.f64 fd271, fd245, fd264;
fma.rn.f64 fd272, fd246, fd262, fd271;
mul.f64 fd273, fd270, fd231;
mul.f64 fd274, fd272, fd232;
mul.f64 fd275, fd270, fd232;
ld.global.v2.f64 {fd276, fd277}, [rd8+64];
mul.f64 fd280, fd276, fd235;
mul.f64 fd281, fd277, fd236;
mul.f64 fd282, fd276, fd236;
mul.f64 fd283, fd245, fd276;
mul.f64 fd284, fd246, fd277;
sub.f64 fd285, fd283, fd284;
mul.f64 fd286, fd245, fd277;
fma.rn.f64 fd287, fd246, fd276, fd286;
mul.f64 fd288, fd285, fd239;
mul.f64 fd289, fd287, fd240;
mul.f64 fd290, fd285, fd240;
mul.f64 fd291, fd245, fd285;
mul.f64 fd292, fd246, fd287;
sub.f64 fd293, fd291, fd292;
mul.f64 fd294, fd245, fd287;
fma.rn.f64 fd295, fd246, fd285, fd294;
mul.f64 fd296, fd293, fd243;
mul.f64 fd297, fd295, fd244;
mul.f64 fd298, fd293, fd244;
and.b32 r16, r10, 112;
add.s32 r17, r9, r16;
barrier.sync 0;
and.b32 r18, r7, 3072;
add.s32 r19, r17, r18;
add.f64 fd299, fd199, fd215;
add.f64 fd300, fd198, fd214;
st.shared.v2.f64 [r19], {fd300, fd299};
fma.rn.f64 fd301, fd246, fd233, fd251;
sub.f64 fd302, fd249, fd250;
st.shared.v2.f64 [r19+128], {fd302, fd301};
fma.rn.f64 fd303, fd256, fd237, fd259;
sub.f64 fd304, fd257, fd258;
st.shared.v2.f64 [r19+256], {fd304, fd303};
fma.rn.f64 fd305, fd264, fd241, fd267;
sub.f64 fd306, fd265, fd266;
st.shared.v2.f64 [r19+384], {fd306, fd305};
sub.f64 fd307, fd273, fd274;
fma.rn.f64 fd308, fd272, fd231, fd275;
st.shared.v2.f64 [r19+512], {fd307, fd308};
fma.rn.f64 fd309, fd277, fd235, fd282;
sub.f64 fd310, fd280, fd281;
st.shared.v2.f64 [r19+640], {fd310, fd309};
fma.rn.f64 fd311, fd287, fd239, fd290;
sub.f64 fd312, fd288, fd289;
st.shared.v2.f64 [r19+768], {fd312, fd311};
fma.rn.f64 fd313, fd295, fd243, fd298;
sub.f64 fd314, fd296, fd297;
st.shared.v2.f64 [r19+896], {fd314, fd313};
barrier.sync 0;
mad.lo.s32 r20, r14, -112, r19;
ld.shared.v2.f64 {fd315, fd316}, [r20];
ld.shared.v2.f64 {fd319, fd320}, [r20+512];
ld.shared.v2.f64 {fd323, fd324}, [r20+1024];
ld.shared.v2.f64 {fd327, fd328}, [r20+1536];
ld.shared.v2.f64 {fd331, fd332}, [r20+2048];
ld.shared.v2.f64 {fd335, fd336}, [r20+2560];
ld.shared.v2.f64 {fd339, fd340}, [r20+3072];
ld.shared.v2.f64 {fd343, fd344}, [r20+3584];
add.f64 fd347, fd315, fd331;
add.f64 fd348, fd316, fd332;
sub.f64 fd349, fd315, fd331;
sub.f64 fd350, fd316, fd332;
add.f64 fd351, fd323, fd339;
add.f64 fd352, fd324, fd340;
sub.f64 fd353, fd323, fd339;
sub.f64 fd354, fd324, fd340;
add.f64 fd355, fd319, fd335;
add.f64 fd356, fd320, fd336;
sub.f64 fd357, fd319, fd335;
sub.f64 fd358, fd320, fd336;
add.f64 fd359, fd327, fd343;
add.f64 fd360, fd328, fd344;
sub.f64 fd361, fd327, fd343;
sub.f64 fd362, fd328, fd344;
add.f64 %1, fd348, fd352;
add.f64 %0, fd347, fd351;
add.f64 %3, fd356, fd360;
add.f64 %2, fd355, fd359;
sub.f64 %5, fd350, fd353;
add.f64 %4, fd349, fd354;
sub.f64 %7, fd358, fd361;
add.f64 %6, fd357, fd362;
sub.f64 %9, fd348, fd352;
sub.f64 %8, fd347, fd351;
sub.f64 %11, fd356, fd360;
sub.f64 %10, fd355, fd359;
add.f64 %13, fd350, fd353;
sub.f64 %12, fd349, fd354;
add.f64 %15, fd358, fd361;
sub.f64 %14, fd357, fd362;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y): "r"(smem), "l"(lut_dp_8_256), "l"(lut_dp_8_32), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<464, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<28>;
.reg .f64 fd<189>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 11;
mov.u32 r3, %8;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f64 fd17, %12, %17;
add.f64 fd18, %13, %19;
sub.f64 fd19, %12, %17;
sub.f64 fd20, %13, %19;
add.f64 fd21, %14, %20;
add.f64 fd22, %16, %21;
sub.f64 fd23, %14, %20;
sub.f64 fd24, %16, %21;
add.f64 fd25, fd17, fd21;
add.f64 fd26, fd18, fd22;
sub.f64 fd27, fd17, fd21;
sub.f64 fd28, fd18, fd22;
add.f64 fd29, fd19, fd24;
sub.f64 fd30, fd20, fd23;
sub.f64 fd31, fd19, fd24;
add.f64 fd32, fd20, fd23;
and.b32 r6, r5, 63;
shl.b32 r7, r5, 4;
cvt.u64.u32 rd2, r7;
and.b64 rd3, rd2, 1008;
mov.u64 rd4, %9;
add.s64 rd5, rd4, rd3;
ld.global.v2.f64 {fd33, fd34}, [rd5];
mul.f64 fd37, fd33, fd29;
mul.f64 fd38, fd34, fd30;
sub.f64 fd39, fd37, fd38;
mul.f64 fd40, fd33, fd30;
fma.rn.f64 fd41, fd34, fd29, fd40;
mul.f64 fd42, fd33, fd33;
mul.f64 fd43, fd34, fd34;
sub.f64 fd44, fd42, fd43;
mul.f64 fd45, fd34, fd33;
fma.rn.f64 fd46, fd34, fd33, fd45;
mul.f64 fd47, fd44, fd27;
mul.f64 fd48, fd46, fd28;
sub.f64 fd49, fd47, fd48;
mul.f64 fd50, fd44, fd28;
fma.rn.f64 fd51, fd46, fd27, fd50;
ld.global.v2.f64 {fd52, fd53}, [rd5+1024];
mul.f64 fd56, fd52, fd31;
mul.f64 fd57, fd53, fd32;
sub.f64 fd58, fd56, fd57;
mul.f64 fd59, fd52, fd32;
fma.rn.f64 fd60, fd53, fd31, fd59;
shl.b32 r8, r5, 5;
and.b32 r9, r8, -2048;
add.s32 r10, r4, r9;
barrier.sync 0;
and.b32 r11, r8, 2016;
add.s32 r12, r10, r11;
st.shared.v2.f64 [r12], {fd25, fd39};
st.shared.v2.f64 [r12+16], {fd49, fd58};
barrier.sync 0;
mad.lo.s32 r13, r6, -24, r12;
ld.shared.f64 fd61, [r13];
ld.shared.f64 fd62, [r13+512];
ld.shared.f64 fd63, [r13+1024];
ld.shared.f64 fd64, [r13+1536];
barrier.sync 0;
st.shared.v2.f64 [r12], {fd26, fd41};
st.shared.v2.f64 [r12+16], {fd51, fd60};
barrier.sync 0;
ld.shared.f64 fd65, [r13];
ld.shared.f64 fd66, [r13+512];
ld.shared.f64 fd67, [r13+1024];
ld.shared.f64 fd68, [r13+1536];
add.f64 fd69, fd61, fd63;
add.f64 fd70, fd65, fd67;
sub.f64 fd71, fd61, fd63;
sub.f64 fd72, fd65, fd67;
add.f64 fd73, fd62, fd64;
add.f64 fd74, fd66, fd68;
sub.f64 fd75, fd62, fd64;
sub.f64 fd76, fd66, fd68;
add.f64 fd77, fd69, fd73;
add.f64 fd78, fd70, fd74;
sub.f64 fd79, fd69, fd73;
sub.f64 fd80, fd70, fd74;
add.f64 fd81, fd71, fd76;
sub.f64 fd82, fd72, fd75;
sub.f64 fd83, fd71, fd76;
add.f64 fd84, fd72, fd75;
and.b32 r14, r5, 60;
bfe.u32 r15, r5, 2, 4;
mul.wide.u32 rd6, r15, 16;
mov.u64 rd7, %10;
add.s64 rd8, rd7, rd6;
ld.global.v2.f64 {fd85, fd86}, [rd8];
mul.f64 fd89, fd85, fd81;
mul.f64 fd90, fd86, fd82;
sub.f64 fd91, fd89, fd90;
mul.f64 fd92, fd85, fd82;
fma.rn.f64 fd93, fd86, fd81, fd92;
mul.f64 fd94, fd85, fd85;
mul.f64 fd95, fd86, fd86;
sub.f64 fd96, fd94, fd95;
mul.f64 fd97, fd86, fd85;
fma.rn.f64 fd98, fd86, fd85, fd97;
mul.f64 fd99, fd96, fd79;
mul.f64 fd100, fd98, fd80;
sub.f64 fd101, fd99, fd100;
mul.f64 fd102, fd96, fd80;
fma.rn.f64 fd103, fd98, fd79, fd102;
ld.global.v2.f64 {fd104, fd105}, [rd8+256];
mul.f64 fd108, fd104, fd83;
mul.f64 fd109, fd105, fd84;
sub.f64 fd110, fd108, fd109;
mul.f64 fd111, fd104, fd84;
fma.rn.f64 fd112, fd105, fd83, fd111;
shl.b32 r16, r5, 3;
and.b32 r17, r16, 24;
add.s32 r18, r10, r17;
barrier.sync 0;
and.b32 r19, r8, 1920;
add.s32 r20, r18, r19;
st.shared.f64 [r20], fd77;
st.shared.f64 [r20+32], fd91;
st.shared.f64 [r20+64], fd101;
st.shared.f64 [r20+96], fd110;
barrier.sync 0;
mad.lo.s32 r21, r14, -24, r20;
ld.shared.f64 fd113, [r21];
ld.shared.f64 fd114, [r21+512];
ld.shared.f64 fd115, [r21+1024];
ld.shared.f64 fd116, [r21+1536];
barrier.sync 0;
st.shared.f64 [r20], fd78;
st.shared.f64 [r20+32], fd93;
st.shared.f64 [r20+64], fd103;
st.shared.f64 [r20+96], fd112;
barrier.sync 0;
ld.shared.f64 fd117, [r21];
ld.shared.f64 fd118, [r21+512];
ld.shared.f64 fd119, [r21+1024];
ld.shared.f64 fd120, [r21+1536];
add.f64 fd121, fd113, fd115;
add.f64 fd122, fd117, fd119;
sub.f64 fd123, fd113, fd115;
sub.f64 fd124, fd117, fd119;
add.f64 fd125, fd114, fd116;
add.f64 fd126, fd118, fd120;
sub.f64 fd127, fd114, fd116;
sub.f64 fd128, fd118, fd120;
add.f64 fd129, fd121, fd125;
add.f64 fd130, fd122, fd126;
sub.f64 fd131, fd121, fd125;
sub.f64 fd132, fd122, fd126;
add.f64 fd133, fd123, fd128;
sub.f64 fd134, fd124, fd127;
sub.f64 fd135, fd123, fd128;
add.f64 fd136, fd124, fd127;
and.b32 r22, r5, 48;
cvt.u64.u32 rd9, r22;
mov.u64 rd10, %11;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd137, fd138}, [rd11];
mul.f64 fd141, fd137, fd133;
mul.f64 fd142, fd138, fd134;
sub.f64 fd143, fd141, fd142;
mul.f64 fd144, fd137, fd134;
fma.rn.f64 fd145, fd138, fd133, fd144;
mul.f64 fd146, fd137, fd137;
mul.f64 fd147, fd138, fd138;
sub.f64 fd148, fd146, fd147;
mul.f64 fd149, fd138, fd137;
fma.rn.f64 fd150, fd138, fd137, fd149;
mul.f64 fd151, fd148, fd131;
mul.f64 fd152, fd150, fd132;
sub.f64 fd153, fd151, fd152;
mul.f64 fd154, fd148, fd132;
fma.rn.f64 fd155, fd150, fd131, fd154;
ld.global.v2.f64 {fd156, fd157}, [rd11+64];
mul.f64 fd160, fd156, fd135;
mul.f64 fd161, fd157, fd136;
sub.f64 fd162, fd160, fd161;
mul.f64 fd163, fd156, fd136;
fma.rn.f64 fd164, fd157, fd135, fd163;
and.b32 r23, r16, 120;
add.s32 r24, r10, r23;
barrier.sync 0;
and.b32 r25, r8, 1536;
add.s32 r26, r24, r25;
st.shared.f64 [r26], fd129;
st.shared.f64 [r26+128], fd143;
st.shared.f64 [r26+256], fd153;
st.shared.f64 [r26+384], fd162;
barrier.sync 0;
mad.lo.s32 r27, r22, -24, r26;
ld.shared.f64 fd165, [r27];
ld.shared.f64 fd166, [r27+512];
ld.shared.f64 fd167, [r27+1024];
ld.shared.f64 fd168, [r27+1536];
barrier.sync 0;
st.shared.f64 [r26], fd130;
st.shared.f64 [r26+128], fd145;
st.shared.f64 [r26+256], fd155;
st.shared.f64 [r26+384], fd164;
barrier.sync 0;
ld.shared.f64 fd169, [r27];
ld.shared.f64 fd170, [r27+512];
ld.shared.f64 fd171, [r27+1024];
ld.shared.f64 fd172, [r27+1536];
add.f64 fd173, fd165, fd167;
add.f64 fd174, fd169, fd171;
sub.f64 fd175, fd165, fd167;
sub.f64 fd176, fd169, fd171;
add.f64 fd177, fd166, fd168;
add.f64 fd178, fd170, fd172;
sub.f64 fd179, fd166, fd168;
sub.f64 fd180, fd170, fd172;
add.f64 %0, fd173, fd177;
add.f64 %1, fd174, fd178;
sub.f64 %3, fd176, fd179;
add.f64 %2, fd175, fd180;
sub.f64 %4, fd173, fd177;
sub.f64 %5, fd174, fd178;
add.f64 %7, fd176, fd179;
sub.f64 %6, fd175, fd180;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y): "r"(smem), "l"(lut_dp_4_256), "l"(lut_dp_4_64), "l"(lut_dp_4_16), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<467, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<56>;
.reg .f64 fd<160>;
.reg .b64 rd<24>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 12;
mov.u32 r3, %4;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
sub.f64 fd9, %12, %14;
sub.f64 fd10, %13, %15;
shl.b32 r6, r5, 5;
and.b32 r7, r6, -4096;
add.s32 r8, r4, r7;
shl.b32 r9, r5, 4;
cvt.u64.u32 rd2, r9;
and.b64 rd3, rd2, 2032;
mov.u64 rd4, %5;
add.s64 rd5, rd4, rd3;
ld.global.v2.f64 {fd11, fd12}, [rd5];
mul.f64 fd15, fd11, fd9;
mul.f64 fd16, fd12, fd10;
mul.f64 fd17, fd11, fd10;
barrier.sync 0;
and.b32 r10, r6, 4064;
add.s32 r11, r8, r10;
add.f64 fd18, %13, %15;
add.f64 fd19, %12, %14;
st.shared.v2.f64 [r11], {fd19, fd18};
sub.f64 fd20, fd15, fd16;
fma.rn.f64 fd21, fd12, fd9, fd17;
st.shared.v2.f64 [r11+16], {fd20, fd21};
barrier.sync 0;
and.b32 r12, r9, 2032;
sub.s32 r13, r11, r12;
ld.shared.v2.f64 {fd22, fd23}, [r13];
ld.shared.v2.f64 {fd26, fd27}, [r13+2048];
sub.f64 fd30, fd22, fd26;
sub.f64 fd31, fd23, fd27;
bfe.u32 r14, r5, 1, 6;
mul.wide.u32 rd6, r14, 16;
mov.u64 rd7, %6;
add.s64 rd8, rd7, rd6;
ld.global.v2.f64 {fd32, fd33}, [rd8];
mul.f64 fd36, fd32, fd30;
mul.f64 fd37, fd33, fd31;
mul.f64 fd38, fd32, fd31;
and.b32 r15, r9, 16;
add.s32 r16, r8, r15;
barrier.sync 0;
and.b32 r17, r6, 4032;
add.s32 r18, r16, r17;
add.f64 fd39, fd23, fd27;
add.f64 fd40, fd22, fd26;
st.shared.v2.f64 [r18], {fd40, fd39};
fma.rn.f64 fd41, fd33, fd30, fd38;
sub.f64 fd42, fd36, fd37;
st.shared.v2.f64 [r18+32], {fd42, fd41};
barrier.sync 0;
and.b32 r19, r9, 2016;
sub.s32 r20, r18, r19;
ld.shared.v2.f64 {fd43, fd44}, [r20];
ld.shared.v2.f64 {fd47, fd48}, [r20+2048];
sub.f64 fd51, fd43, fd47;
sub.f64 fd52, fd44, fd48;
bfe.u32 r21, r5, 2, 5;
mul.wide.u32 rd9, r21, 16;
mov.u64 rd10, %7;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd53, fd54}, [rd11];
mul.f64 fd57, fd53, fd51;
mul.f64 fd58, fd54, fd52;
mul.f64 fd59, fd53, fd52;
and.b32 r22, r9, 48;
add.s32 r23, r8, r22;
barrier.sync 0;
and.b32 r24, r6, 3968;
add.s32 r25, r23, r24;
add.f64 fd60, fd44, fd48;
add.f64 fd61, fd43, fd47;
st.shared.v2.f64 [r25], {fd61, fd60};
fma.rn.f64 fd62, fd54, fd51, fd59;
sub.f64 fd63, fd57, fd58;
st.shared.v2.f64 [r25+64], {fd63, fd62};
barrier.sync 0;
and.b32 r26, r9, 1984;
sub.s32 r27, r25, r26;
ld.shared.v2.f64 {fd64, fd65}, [r27];
ld.shared.v2.f64 {fd68, fd69}, [r27+2048];
sub.f64 fd72, fd64, fd68;
sub.f64 fd73, fd65, fd69;
bfe.u32 r28, r5, 3, 4;
mul.wide.u32 rd12, r28, 16;
mov.u64 rd13, %8;
add.s64 rd14, rd13, rd12;
ld.global.v2.f64 {fd74, fd75}, [rd14];
mul.f64 fd78, fd74, fd72;
mul.f64 fd79, fd75, fd73;
mul.f64 fd80, fd74, fd73;
and.b32 r29, r9, 112;
add.s32 r30, r8, r29;
barrier.sync 0;
and.b32 r31, r6, 3840;
add.s32 r32, r30, r31;
add.f64 fd81, fd65, fd69;
add.f64 fd82, fd64, fd68;
st.shared.v2.f64 [r32], {fd82, fd81};
fma.rn.f64 fd83, fd75, fd72, fd80;
sub.f64 fd84, fd78, fd79;
st.shared.v2.f64 [r32+128], {fd84, fd83};
barrier.sync 0;
and.b32 r33, r9, 1920;
sub.s32 r34, r32, r33;
ld.shared.v2.f64 {fd85, fd86}, [r34];
ld.shared.v2.f64 {fd89, fd90}, [r34+2048];
sub.f64 fd93, fd85, fd89;
sub.f64 fd94, fd86, fd90;
and.b32 r35, r5, 112;
cvt.u64.u32 rd15, r35;
mov.u64 rd16, %9;
add.s64 rd17, rd16, rd15;
ld.global.v2.f64 {fd95, fd96}, [rd17];
mul.f64 fd99, fd95, fd93;
mul.f64 fd100, fd96, fd94;
mul.f64 fd101, fd95, fd94;
and.b32 r36, r9, 240;
add.s32 r37, r8, r36;
barrier.sync 0;
and.b32 r38, r6, 3584;
add.s32 r39, r37, r38;
add.f64 fd102, fd86, fd90;
add.f64 fd103, fd85, fd89;
st.shared.v2.f64 [r39], {fd103, fd102};
fma.rn.f64 fd104, fd96, fd93, fd101;
sub.f64 fd105, fd99, fd100;
st.shared.v2.f64 [r39+256], {fd105, fd104};
barrier.sync 0;
and.b32 r40, r9, 1792;
sub.s32 r41, r39, r40;
ld.shared.v2.f64 {fd106, fd107}, [r41];
ld.shared.v2.f64 {fd110, fd111}, [r41+2048];
sub.f64 fd114, fd106, fd110;
sub.f64 fd115, fd107, fd111;
bfe.u32 r42, r5, 5, 2;
mul.wide.u32 rd18, r42, 16;
mov.u64 rd19, %10;
add.s64 rd20, rd19, rd18;
ld.global.v2.f64 {fd116, fd117}, [rd20];
mul.f64 fd120, fd116, fd114;
mul.f64 fd121, fd117, fd115;
mul.f64 fd122, fd116, fd115;
and.b32 r43, r9, 496;
add.s32 r44, r8, r43;
barrier.sync 0;
and.b32 r45, r6, 3072;
add.s32 r46, r44, r45;
add.f64 fd123, fd107, fd111;
add.f64 fd124, fd106, fd110;
st.shared.v2.f64 [r46], {fd124, fd123};
fma.rn.f64 fd125, fd117, fd114, fd122;
sub.f64 fd126, fd120, fd121;
st.shared.v2.f64 [r46+512], {fd126, fd125};
barrier.sync 0;
and.b32 r47, r9, 1536;
sub.s32 r48, r46, r47;
ld.shared.v2.f64 {fd127, fd128}, [r48];
ld.shared.v2.f64 {fd131, fd132}, [r48+2048];
sub.f64 fd135, fd127, fd131;
sub.f64 fd136, fd128, fd132;
bfe.u32 r49, r5, 6, 1;
mul.wide.u32 rd21, r49, 16;
mov.u64 rd22, %11;
add.s64 rd23, rd22, rd21;
ld.global.v2.f64 {fd137, fd138}, [rd23];
mul.f64 fd141, fd137, fd135;
mul.f64 fd142, fd138, fd136;
mul.f64 fd143, fd137, fd136;
and.b32 r50, r9, 1008;
add.s32 r51, r8, r50;
barrier.sync 0;
and.b32 r52, r6, 2048;
add.s32 r53, r51, r52;
add.f64 fd144, fd128, fd132;
add.f64 fd145, fd127, fd131;
st.shared.v2.f64 [r53], {fd145, fd144};
fma.rn.f64 fd146, fd138, fd135, fd143;
sub.f64 fd147, fd141, fd142;
st.shared.v2.f64 [r53+1024], {fd147, fd146};
barrier.sync 0;
and.b32 r54, r9, 1024;
sub.s32 r55, r53, r54;
ld.shared.v2.f64 {fd148, fd149}, [r55];
ld.shared.v2.f64 {fd152, fd153}, [r55+2048];
add.f64 %1, fd149, fd153;
add.f64 %0, fd148, fd152;
sub.f64 %3, fd149, fd153;
sub.f64 %2, fd148, fd152;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y): "r"(smem), "l"(lut_dp_2_256), "l"(lut_dp_2_128), "l"(lut_dp_2_64), "l"(lut_dp_2_32), "l"(lut_dp_2_16), "l"(lut_dp_2_8), "l"(lut_dp_2_4), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<466, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<56>;
.reg .f64 fd<132>;
.reg .b64 rd<24>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 11;
mov.u32 r3, %4;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f64 fd9, %12, %14;
add.f64 fd10, %13, %15;
sub.f64 fd11, %12, %14;
sub.f64 fd12, %13, %15;
shl.b32 r6, r5, 4;
cvt.u64.u32 rd2, r6;
and.b64 rd3, rd2, 2032;
mov.u64 rd4, %5;
add.s64 rd5, rd4, rd3;
ld.global.v2.f64 {fd13, fd14}, [rd5];
mul.f64 fd17, fd13, fd11;
mul.f64 fd18, fd14, fd12;
sub.f64 fd19, fd17, fd18;
mul.f64 fd20, fd13, fd12;
fma.rn.f64 fd21, fd14, fd11, fd20;
and.b32 r7, r6, -2048;
add.s32 r8, r4, r7;
barrier.sync 0;
and.b32 r9, r6, 2032;
add.s32 r10, r8, r9;
st.shared.v2.f64 [r10], {fd9, fd19};
barrier.sync 0;
shl.b32 r11, r5, 3;
and.b32 r12, r11, 1016;
sub.s32 r13, r10, r12;
ld.shared.f64 fd22, [r13];
ld.shared.f64 fd23, [r13+1024];
barrier.sync 0;
st.shared.v2.f64 [r10], {fd10, fd21};
barrier.sync 0;
ld.shared.f64 fd24, [r13];
ld.shared.f64 fd25, [r13+1024];
add.f64 fd26, fd22, fd23;
add.f64 fd27, fd24, fd25;
sub.f64 fd28, fd22, fd23;
sub.f64 fd29, fd24, fd25;
bfe.u32 r14, r5, 1, 6;
mul.wide.u32 rd6, r14, 16;
mov.u64 rd7, %6;
add.s64 rd8, rd7, rd6;
ld.global.v2.f64 {fd30, fd31}, [rd8];
mul.f64 fd34, fd30, fd28;
mul.f64 fd35, fd31, fd29;
sub.f64 fd36, fd34, fd35;
mul.f64 fd37, fd30, fd29;
fma.rn.f64 fd38, fd31, fd28, fd37;
and.b32 r15, r11, 8;
add.s32 r16, r8, r15;
barrier.sync 0;
and.b32 r17, r6, 2016;
add.s32 r18, r16, r17;
st.shared.f64 [r18], fd26;
st.shared.f64 [r18+16], fd36;
barrier.sync 0;
and.b32 r19, r11, 1008;
sub.s32 r20, r18, r19;
ld.shared.f64 fd39, [r20];
ld.shared.f64 fd40, [r20+1024];
barrier.sync 0;
st.shared.f64 [r18], fd27;
st.shared.f64 [r18+16], fd38;
barrier.sync 0;
ld.shared.f64 fd41, [r20];
ld.shared.f64 fd42, [r20+1024];
add.f64 fd43, fd39, fd40;
add.f64 fd44, fd41, fd42;
sub.f64 fd45, fd39, fd40;
sub.f64 fd46, fd41, fd42;
bfe.u32 r21, r5, 2, 5;
mul.wide.u32 rd9, r21, 16;
mov.u64 rd10, %7;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd47, fd48}, [rd11];
mul.f64 fd51, fd47, fd45;
mul.f64 fd52, fd48, fd46;
sub.f64 fd53, fd51, fd52;
mul.f64 fd54, fd47, fd46;
fma.rn.f64 fd55, fd48, fd45, fd54;
and.b32 r22, r11, 24;
add.s32 r23, r8, r22;
barrier.sync 0;
and.b32 r24, r6, 1984;
add.s32 r25, r23, r24;
st.shared.f64 [r25], fd43;
st.shared.f64 [r25+32], fd53;
barrier.sync 0;
and.b32 r26, r11, 992;
sub.s32 r27, r25, r26;
ld.shared.f64 fd56, [r27];
ld.shared.f64 fd57, [r27+1024];
barrier.sync 0;
st.shared.f64 [r25], fd44;
st.shared.f64 [r25+32], fd55;
barrier.sync 0;
ld.shared.f64 fd58, [r27];
ld.shared.f64 fd59, [r27+1024];
add.f64 fd60, fd56, fd57;
add.f64 fd61, fd58, fd59;
sub.f64 fd62, fd56, fd57;
sub.f64 fd63, fd58, fd59;
bfe.u32 r28, r5, 3, 4;
mul.wide.u32 rd12, r28, 16;
mov.u64 rd13, %8;
add.s64 rd14, rd13, rd12;
ld.global.v2.f64 {fd64, fd65}, [rd14];
mul.f64 fd68, fd64, fd62;
mul.f64 fd69, fd65, fd63;
sub.f64 fd70, fd68, fd69;
mul.f64 fd71, fd64, fd63;
fma.rn.f64 fd72, fd65, fd62, fd71;
and.b32 r29, r11, 56;
add.s32 r30, r8, r29;
barrier.sync 0;
and.b32 r31, r6, 1920;
add.s32 r32, r30, r31;
st.shared.f64 [r32], fd60;
st.shared.f64 [r32+64], fd70;
barrier.sync 0;
and.b32 r33, r11, 960;
sub.s32 r34, r32, r33;
ld.shared.f64 fd73, [r34];
ld.shared.f64 fd74, [r34+1024];
barrier.sync 0;
st.shared.f64 [r32], fd61;
st.shared.f64 [r32+64], fd72;
barrier.sync 0;
ld.shared.f64 fd75, [r34];
ld.shared.f64 fd76, [r34+1024];
add.f64 fd77, fd73, fd74;
add.f64 fd78, fd75, fd76;
sub.f64 fd79, fd73, fd74;
sub.f64 fd80, fd75, fd76;
and.b32 r35, r5, 112;
cvt.u64.u32 rd15, r35;
mov.u64 rd16, %9;
add.s64 rd17, rd16, rd15;
ld.global.v2.f64 {fd81, fd82}, [rd17];
mul.f64 fd85, fd81, fd79;
mul.f64 fd86, fd82, fd80;
sub.f64 fd87, fd85, fd86;
mul.f64 fd88, fd81, fd80;
fma.rn.f64 fd89, fd82, fd79, fd88;
and.b32 r36, r11, 120;
add.s32 r37, r8, r36;
barrier.sync 0;
and.b32 r38, r6, 1792;
add.s32 r39, r37, r38;
st.shared.f64 [r39], fd77;
st.shared.f64 [r39+128], fd87;
barrier.sync 0;
and.b32 r40, r11, 896;
sub.s32 r41, r39, r40;
ld.shared.f64 fd90, [r41];
ld.shared.f64 fd91, [r41+1024];
barrier.sync 0;
st.shared.f64 [r39], fd78;
st.shared.f64 [r39+128], fd89;
barrier.sync 0;
ld.shared.f64 fd92, [r41];
ld.shared.f64 fd93, [r41+1024];
add.f64 fd94, fd90, fd91;
add.f64 fd95, fd92, fd93;
sub.f64 fd96, fd90, fd91;
sub.f64 fd97, fd92, fd93;
bfe.u32 r42, r5, 5, 2;
mul.wide.u32 rd18, r42, 16;
mov.u64 rd19, %10;
add.s64 rd20, rd19, rd18;
ld.global.v2.f64 {fd98, fd99}, [rd20];
mul.f64 fd102, fd98, fd96;
mul.f64 fd103, fd99, fd97;
sub.f64 fd104, fd102, fd103;
mul.f64 fd105, fd98, fd97;
fma.rn.f64 fd106, fd99, fd96, fd105;
and.b32 r43, r11, 248;
add.s32 r44, r8, r43;
barrier.sync 0;
and.b32 r45, r6, 1536;
add.s32 r46, r44, r45;
st.shared.f64 [r46], fd94;
st.shared.f64 [r46+256], fd104;
barrier.sync 0;
and.b32 r47, r11, 768;
sub.s32 r48, r46, r47;
ld.shared.f64 fd107, [r48];
ld.shared.f64 fd108, [r48+1024];
barrier.sync 0;
st.shared.f64 [r46], fd95;
st.shared.f64 [r46+256], fd106;
barrier.sync 0;
ld.shared.f64 fd109, [r48];
ld.shared.f64 fd110, [r48+1024];
add.f64 fd111, fd107, fd108;
add.f64 fd112, fd109, fd110;
sub.f64 fd113, fd107, fd108;
sub.f64 fd114, fd109, fd110;
bfe.u32 r49, r5, 6, 1;
mul.wide.u32 rd21, r49, 16;
mov.u64 rd22, %11;
add.s64 rd23, rd22, rd21;
ld.global.v2.f64 {fd115, fd116}, [rd23];
mul.f64 fd119, fd115, fd113;
mul.f64 fd120, fd116, fd114;
sub.f64 fd121, fd119, fd120;
mul.f64 fd122, fd115, fd114;
fma.rn.f64 fd123, fd116, fd113, fd122;
and.b32 r50, r11, 504;
add.s32 r51, r8, r50;
barrier.sync 0;
and.b32 r52, r6, 1024;
add.s32 r53, r51, r52;
st.shared.f64 [r53], fd111;
st.shared.f64 [r53+512], fd121;
barrier.sync 0;
and.b32 r54, r11, 512;
sub.s32 r55, r53, r54;
ld.shared.f64 fd124, [r55];
ld.shared.f64 fd125, [r55+1024];
barrier.sync 0;
st.shared.f64 [r53], fd112;
st.shared.f64 [r53+512], fd123;
barrier.sync 0;
ld.shared.f64 fd126, [r55];
ld.shared.f64 fd127, [r55+1024];
add.f64 %0, fd124, fd125;
add.f64 %1, fd126, fd127;
sub.f64 %2, fd124, fd125;
sub.f64 %3, fd126, fd127;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y): "r"(smem), "l"(lut_dp_2_256), "l"(lut_dp_2_128), "l"(lut_dp_2_64), "l"(lut_dp_2_32), "l"(lut_dp_2_16), "l"(lut_dp_2_8), "l"(lut_dp_2_4), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y));
};


#endif
